#!/bin/bash
#: Title      : test_simboxes
#: Date       : 2016-10-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simboxes$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f correct_ascii.tac ] || [ ! -f correct_ascii2.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_float.tac ] || [ ! -f correct_float2.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Default settings. \n"
printf " Expected result: Usable ASCII matrix is created. \n\n"

rm -f test.dat test.bin ascii.v
$PROGRAM 32 10 8 2 test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

asc2flat test.dat test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img --silent -scanner=HRRT test.bin ascii.v 10 1 32 32
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s ascii.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ascii.v ascii.v ascii.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_ascii.tac ascii.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Mask extends over all planes. \n"
printf " Expected result: Usable ASCII matrix is created. \n\n"

rm -f test2.dat test.bin ascii2.v
$PROGRAM 16 5 2 5 test2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

asc2flat test2.dat test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img --silent -scanner=HRRT test.bin ascii2.v 5 1 16 16
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s ascii2.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ascii2.v ascii2.v ascii2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_ascii2.tac ascii2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 1.1.0 \n"
printf " Test case: Option -format=float. \n"
printf " Expected result: Usable flat binary file is created. \n\n"

rm -f test.bin float.img
$PROGRAM -format=float 128 15 64 5 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=931 test.bin float.img 15 1 128 128
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s float.img
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft float.img float.img float.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_float.tac float.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Separate full-sized mask on each plane. \n"
printf " Expected result: Usable flat binary file is created. \n\n"

rm -f test.bin float2.img
$PROGRAM -format=float 128 15 128 1 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=931 test.bin float2.img 15 1 128 128
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s float2.img
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft float2.img float2.img float2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_float2.tac float2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
