#!/bin/bash
#: Title      : test_simcirc
#: Date       : 2023-03-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simcirc$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f correct_segm.tac ]; then
printf "start[seconds]	end[unknown]	Mask-1	Mask-2	Mask-3	Mask-4\n" > correct_segm.tac
printf "0.0	0.0	1.0e+00	2.0e+00	3.0e+00	4.0e+00\n" >> correct_segm.tac
fi

if [ ! -f correct_ring4.tac ]; then
printf "start[seconds]	end[unknown]	Mask-1	Mask-2\n" > correct_ring4.tac
printf "0.0	0.0	1.0e+00	2.0e+00\n" >> correct_ring4.tac
fi

if [ ! -f correct_ring5.tac ]; then
printf "start[seconds]	end[unknown]	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6\n" > correct_ring5.tac
printf "0.0	0.0	1.0e+00	2.0e+00	3.0e+00	4.0e+00	5.0e+00	6.0e+00\n" >> correct_ring5.tac
fi

if [ ! -f twoframe.tac ]; then
printf "start[minutes]	end[unknown]	Mask-1	Mask-2\n" > twoframe.tac
printf "0.00	1.00	0.00	10.0\n" >> twoframe.tac
printf "10.0	15.0	10.0	0.00\n" >> twoframe.tac
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Default settings. \n"
printf " Expected result: ASCII matrix is created, usable for creating image. \n\n"

rm -f test.dat test.bin ascii.v
$PROGRAM 64 8 test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

asc2flat test.dat test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ascii.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ascii.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Option -format=float. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin float.v
$PROGRAM -format=float 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin float.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb float.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Inverted values with option -inv. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin invert.v
$PROGRAM -inv -format=float 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin invert.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb invert.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.3.0 \n"
printf " Test case: Option -segm. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin segm.v segm.tac
$PROGRAM -segm=4 -format=float 64 52 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin segm.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft segm.v segm.v segm.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_segm.tac segm.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb segm.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case: Ring with option -diam2. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring.v
$PROGRAM -format=float -diam2=13 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Diameters can be in reverse order. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring2.v
$PROGRAM -format=float -diam2=8 64 13 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring2.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring2.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Ring with inverted values. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring3.v
$PROGRAM -inv -format=float -diam2=13 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring3.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring3.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.2.0 \n"
printf " Test case: Ring with filled hole. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring4.v ring4.tac
$PROGRAM -iring=1 -format=float -diam2=56 64 16 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring4.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ring4.v ring4.v ring4.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_ring4.tac ring4.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif -rb ring4.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.3.0 \n"
printf " Test case: Ring with segments and filled hole. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring5.v ring5.tac
$PROGRAM -iring=1 -segm=5 -format=float -diam2=56 64 16 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring5.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ring5.v ring5.v ring5.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_ring5.tac ring5.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif -rb ring5.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.0 \n"
printf " Play case: Ring and Gaussian filter. \n\n"

rm -f test.bin play300o.v play300s.v
$PROGRAM -iring=1 -format=float -diam2=40 128 80 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin mask.v 1 1 128 128
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

dft2img -tpl=mask.v twoframe.tac play300o.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif play300o.v

imgfiltg -method=FIR play300o.v play300s.v 10
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif play300s.v
img2dft play300s.v mask.v play300s.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc play300o.v + 1 play300p.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

imgfiltg -method=FIR play300p.v play300ps.v 10
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif play300ps.v
img2dft play300ps.v mask.v play300ps.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
#cat twoframe.tac play300s.tac play300ps.tac
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
