#!/bin/bash
#: Title      : test_simelli
#: Date       : 2023-02-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simelli$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Reasonable and default settings to make a ball. \n"
printf " Expected result: Image matrix is created for visual inspection. \n\n"

rm -f test100.nii
$PROGRAM 64 64 64 32 32 32 test100
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif test100.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Reasonable and default settings to make triaxial ellipsoid. \n"
printf " Expected result: Image matrix is created for visual inspection. \n\n"

rm -f test101.nii
$PROGRAM 64 64 64 60 20 40 test101
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif test101.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Different image dimensions. \n"
printf " Expected result: Image matrix is created for visual inspection. \n\n"

rm -f test110.nii
$PROGRAM 64 32 40 60 20 40 test110
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif test110.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Move centre in all directions. \n"
printf " Expected result: Image matrix is created for visual inspection. \n\n"

rm -f test120.nii
$PROGRAM -cx=-20 -cy=-20 -cz=10 64 64 64 60 20 40 test120
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif test120.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case: Make two ellipsoids with different sizes. \n"
printf " Expected result: Image matrix is created for visual inspection. \n\n"

rm -f test200.nii
$PROGRAM -cx=0 -cy=0 -cz=-20 64 64 64 50 30 20 temp1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -cx=-10 -cy=+10 -cz=0 64 64 64 30 20 10 temp2
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc temp1.nii + temp2.nii test200.nii

img2tif test200.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
