#!/bin/bash
#: Title      : test_tac2nii
#: Date       : 2023-03-25
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tac2nii$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f test.tac ]; then
  printf "\n creating test.tac \n"
  printf "start[seconds]	end	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6	Mask-7	Mask-8	Mask-9\n" > test.tac
  printf "0.0	60	1	2	3	4	5	6	7	8	9\n" >> test.tac
  printf "120	240	-2	-1	0	1	2	3	4	5	6\n" >> test.tac
fi

if [ ! -f testna.tac ]; then
  printf "\n creating testna.tac \n"
  printf "start[seconds]	end[Bq/cc]	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6	Mask-7	Mask-8	Mask-9\n" > testna.tac
  printf "0.0	60	1	2	3	4	5	6	7	8	9\n" >> testna.tac
  printf "120	240	-2	.	0	1	2	3	4	5	6\n" >> testna.tac
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Make small image, SIF, and template image. \n"
printf " Expected result: With template correct TACs can be extracted from created image. \n\n"

rm -f output.tac

$PROGRAM test.tac 4 4 4 output template
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.nii template.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.01 -x=y -y=y -xunit=y -yunit=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

#rm -f output.nii template.nii


printf "\n\n 1.0.1 \n"
printf " Test case: Make larger image, SIF, and template image. \n"
printf " Expected result: With template correct TACs can be extracted from created image. \n\n"

cp -f test.tac temp.tac
tacunit -xconv=min temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.tac

$PROGRAM temp.tac 256 256 256 output template
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.nii template.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.01 -x=y -y=y -xunit=y -yunit=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

#rm -f output.nii template.nii output.sif temp.tac output.tac



printf "\n\n 1.1.0 \n"
printf " Test case: TAC has a missing value. \n"
printf " Expected result 1: Image will have missing values, respectively. \n"
printf " Expected result 2: Correct template and SIF written. \n\n"

rm -f output.tac

$PROGRAM testna.tac 4 4 4 output template
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.nii template.nii output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.01 -x=y -y=y -xunit=y -yunit=n testna.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

