#!/bin/bash
#: Title      : test_convsurg
#: Date       : 2019-02-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../convsurg$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f step.dat ] || [ ! -f excel_stepconv.csv ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f boxcar.dat ] || [ ! -f blood.fit ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f step01s.dat ]; then
  interpol -c=0,300,0.1 step.dat step01s.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f boxcar01s.dat ]; then
  interpol -c=0,150,0.1 boxcar.dat boxcar01s.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f blood.bld ]; then
  fit2dat -c=0,60,0.02 blood.fit blood.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Step input data has sample frequency of 0.1 and starts from zero. \n"
printf " Expected result: Simulated TAC is the same as what Excel gives. \n\n"


rm -f output01s_conv.dat

$PROGRAM -d3 step01s.dat 1 0.1 output01s_conv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -mt="Sample frequency of 0.1" step01s.svg -l step.dat output01s_conv.dat excel_stepconv.csv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=0.1 excel_stepconv.csv output01s_conv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " test case 1: Option -auc=1. \n"
printf " Test case 2: Boxcar input data has sample frequency of 0.1 and starts from zero. \n"
printf " Expected result: Simulated TAC has the same AUC as the input TAC. \n\n"


rm -f output01s_conv.dat

$PROGRAM -d3 -auc=1 boxcar01s.dat 1 0.15 output01s_conv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -mt="Sample frequency of 0.1" boxcar01s.svg -l boxcar01s.dat output01s_conv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -i -x=150 boxcar01s.dat test1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=150 output01s_conv.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 test1.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n----------------------------------------------------------------\n"


printf "\n 1.2.0 \n"
printf " Test case: Using with real looking TAC. \n"
printf " Expected result: No error and result looks nice. \n\n"

$PROGRAM -auc=1 blood.bld 1 1 blood_conv1.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -auc=0.8 blood.bld 1 1 blood_conv2.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -auc=1.2 blood.bld 1 1 blood_conv3.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -x2=10 blood_conv.svg -l blood.bld blood_conv1.bld blood_conv2.bld blood_conv3.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

