#!/bin/bash
#: Title      : test_sim_pkcp
#: Date       : 2017-01-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../sim_pkcp$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f correct_o2cm.tac ] || [ ! -f correct_o1cm.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f o2cm.par ]; then
  printf "# model := O2CM\n"                                           > o2cm.par
  printf "# studynr := test1\n"                                       >> o2cm.par
  printf "# fit_start := 0 min\n"                                     >> o2cm.par
  printf "# fit_end := 1440 min\n"                                    >> o2cm.par
  printf "parameters,ED/V1[umol/L],ka[1/h],ke[1/h],kd[1/h],kr[1/h]\n" >> o2cm.par
  printf "Cp,1000,2,0.4,0.4,0.1\n"                                    >> o2cm.par
fi

if [ ! -f o1cm.par ]; then
  printf "# model := O1CM\n"                            > o1cm.par
  printf "# studynr := test2\n"                        >> o1cm.par
  printf "# fit_start := 0 min\n"                      >> o1cm.par
  printf "# fit_end := 1440 min\n"                     >> o1cm.par
  printf "parameters,ED/V1[umol/L],ka[1/h],ke[1/h]\n"  >> o1cm.par
  printf "Cp,1000,2,0.2\n"                             >> o1cm.par
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Only PAR filename given as argument. \n"
printf " Expected result: Error about unknown model. \n\n"

rm -f stdout.txt output.par
$PROGRAM output.par &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unknown simulation model; use option -model."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -model=o2cm. \n"
printf " Expected result: Template par file is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=o2cm output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model O2CM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -model=O1CM. \n"
printf " Expected result: Template par file is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=O1CM output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model O1CM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n----------------------------------------------------------------\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Simulate plasma data using O2CM. \n"
printf " Test case 2: Valid PAR file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Expected result: Correct curve is simulated. \n\n"

rm -f output.tac o2cm.svg temp.tac

$PROGRAM o2cm.par output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -mt="O2CM" o2cm.svg -s correct_o2cm.tac -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -f=correct_o2cm.tac output.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=n -abs=1 -rel=0.1 correct_o2cm.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Simulate plasma data using O1CM. \n"
printf " Test case 2: Valid PAR file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Expected result: Correct curve is simulated. \n\n"

rm -f output.tac o1cm.svg temp.tac

$PROGRAM o1cm.par output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -mt="O1CM" o1cm.svg -s correct_o1cm.tac -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -f=correct_o1cm.tac output.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=n -abs=1 -rel=0.1 correct_o1cm.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Test some errors \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption output.par &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Extra argument when simulating. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM o2sim.par output.tac extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.2.0 \n"
printf " Test case: Param file does not exist, but output filename given. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.par output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.par)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

