#!/bin/bash
#: Title      : test_sim_rtcm
#: Date       : 2014-12-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../sim_rtcm$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f mpaplasma.dat ] || [ ! -f rpplasma.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f mpaplasma.bld ]; then
  tacformat -f=PMOD mpaplasma.dat mpaplasma.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren mpaplasma.bld 0 plasma
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -mt="[C-11]MP4A plasma input" mpaplasma.svg -l mpaplasma.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f rpplasma.bld ]; then
  tacformat -f=PMOD rpplasma.dat rpplasma.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren rpplasma.bld 0 plasma
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -mt="[C-11]Raclopride plasma input" rpplasma.svg -l rpplasma.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Only PAR filename given as argument. \n"
printf " Expected result: Error about unknown model. \n\n"

rm -f stdout.txt output.par
$PROGRAM output.par &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "unknown simulation model; use option -model."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -SRTM. \n"
printf " Expected result: Template par file for SRTM is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=srtm output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model SRTM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -FRTM. \n"
printf " Expected result: Template par file for FRTM is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=FRTM output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model FRTM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=RTCM output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model FRTM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -RRTM. \n"
printf " Expected result: Template par file for RRTM is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=rrtm output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model RRTM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.4 \n"
printf " Test case 1: Only PAR filename given as argument. \n"
printf " Test case 2: Model given with option -TRTM. \n"
printf " Expected result: Template par file for TRTM is made. \n\n"

rm -f stdout.txt output.par
$PROGRAM -model=Trtm output.par &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.par model TRTM
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n----------------------------------------------------------------\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Simulate TAC using SRTM. \n"
printf " Test case 2: Valid PAR and REF file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Expected result: Correct TAC is simulated. \n\n"

rm -f output.tac srtm.par rpref.tac rptis.tac

printf "# model := SRTM\n"        > srtm.par
printf "parameters,R1,k2,BPnd\n" >> srtm.par
printf "tis1,1.391,0.489,3.27\n" >> srtm.par

p2t_3c -nosub rpplasma.bld 0.11 0.35 0 0 0 0 rpref.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
p2t_3c -nosub rpplasma.bld 0.153 0.1144626 0 0 0 0 rptis.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM srtm.par rpref.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg srtm.svg -l rptis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -tacnames=n -abs=0.1 -rel=0.1 rptis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n----------------------------------------------------------------\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Simulate TAC using TRTM. \n"
printf " Test case 2: Valid PAR and REF file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Expected result: Correct TAC is simulated. \n\n"

rm -f output.tac trtm.par mparef.tac mpatis.tac

printf "# model := TRTM\n"        > trtm.par
printf "parameters,R1,k2,k3\n"   >> trtm.par
printf "tis1,0.8,0.08,0.07\n"    >> trtm.par

p2t_3c -nosub mpaplasma.bld 0.5 0.10 30 0 0 0 mparef.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
p2t_3c -nosub mpaplasma.bld 0.4 0.08 0.07 0 0 0 mpatis.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM trtm.par mparef.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg trtm.svg -l mpatis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -tacnames=n -abs=0.1 -rel=0.1 mpatis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n----------------------------------------------------------------\n"


printf "\n 1.3.0 \n"
printf " Test case 1: Simulate TAC using RRTM. \n"
printf " Test case 2: Valid PAR and REF file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Expected result: Correct TAC is simulated. \n\n"

rm -f output.tac rrtm.par redref.tac redtis.tac

printf "# model := RRTM\n"             > rrtm.par
printf "parameters,R1,k2,k3\n"        >> rrtm.par
printf "tis1,0.33333333,0.04,0.005\n" >> rrtm.par

p2t_3c -nosub rpplasma.bld 0.06 0.12 0 0 0 0 redref.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
p2t_3c -nosub rpplasma.bld 0.02 0.04 0.005 0 0 0 redtis.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM rrtm.par redref.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg rrtm.svg -l redtis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -tacnames=n -abs=0.1 -rel=0.1 redtis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n----------------------------------------------------------------\n"


printf "\n 1.4.0 \n"
printf " Test case 1: Simulate TAC using FRTM. \n"
printf " Test case 2: Valid PAR and REF file. \n"
printf " Test case 3: Model specified in PAR file. \n"
printf " Test case 4: Sub regions not saved. \n"
printf " Expected result: Correct TAC is simulated. \n\n"

rm -f output.tac frtm.par fulref.tac fultis.tac

printf "# model := FRTM\n"              > frtm.par
printf "parameters,R1,k2,k3,BPnd\n"    >> frtm.par
printf "tis1,1.391,0.489,0.303,3.27\n" >> frtm.par

p2t_3c -nosub rpplasma.bld 0.11 0.35 0 0 0 0 fulref.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
p2t_3c -nosub rpplasma.bld 0.153 0.489 0.303 0.0926 0 0 fultis.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM frtm.par fulref.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg frtm.svg -l fultis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -tacnames=n -abs=0.1 -rel=0.1 fultis.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.4.1 \n"
printf " Test case 1: Simulate TAC using FRTM. \n"
printf " Test case 2: Valid PAR and REF file. \n"
printf " Test case 3: Model specified with command-line option. \n"
printf " Test case 4: Sub regions are saved. \n"
printf " Not tested: Correctness of free and bound TACs. \n\n"
printf " Expected result: Correct TAC is simulated. \n\n"

rm -f output.tac frtm2.par

printf "parameters,R1,k2,k3,BPnd\n"     > frtm2.par
printf "tis1,1.391,0.489,0.303,3.27\n" >> frtm2.par

$PROGRAM -model=frtm -sub frtm2.par fulref.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg frtm2.svg -l output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[1] tis1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[2] tis1_free
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift tacname[3] tis1_bound
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr temp.tac output.tac 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=n -abs=0.1 -rel=0.1 fultis.tac temp.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Test some errors \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption output.par &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Extra argument when just saving template par file. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM output.par extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing filename for simulated TACs."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Extra argument when simulating. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM output.par input.tac output.tac extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.2.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.par rpref.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.par)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM srtm.par nonexistingfile.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.tac)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

