#!/bin/bash
#: Title      : test_simcmdk
#: Date       : 2023-04-06
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simcmdk$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f bolus.sif ]; then
rm -f r1tcm.tac
printf "19/03/2023 14:17:50 41 2 1 BOLUS1 C-11\n" > bolus.sif
printf "0 10\n" >> bolus.sif
printf "10 20\n" >> bolus.sif
printf "20 30\n" >> bolus.sif
printf "30 40\n" >> bolus.sif
printf "40 50\n" >> bolus.sif
printf "50 60\n" >> bolus.sif
printf "60 70\n" >> bolus.sif
printf "70 80\n" >> bolus.sif
printf "80 90\n" >> bolus.sif
printf "90 100\n" >> bolus.sif
printf "100 110\n" >> bolus.sif
printf "110 120\n" >> bolus.sif
printf "120 140\n" >> bolus.sif
printf "140 160\n" >> bolus.sif
printf "160 180\n" >> bolus.sif
printf "180 210\n" >> bolus.sif
printf "210 240\n" >> bolus.sif
printf "240 270\n" >> bolus.sif
printf "270 300\n" >> bolus.sif
printf "300 330\n" >> bolus.sif
printf "330 360\n" >> bolus.sif
printf "360 390\n" >> bolus.sif
printf "390 420\n" >> bolus.sif
printf "420 480\n" >> bolus.sif
printf "480 540\n" >> bolus.sif
printf "540 600\n" >> bolus.sif
printf "600 720\n" >> bolus.sif
printf "720 840\n" >> bolus.sif
printf "840 960\n" >> bolus.sif
printf "960 1080\n" >> bolus.sif
printf "1080 1200\n" >> bolus.sif
printf "1200 1500\n" >> bolus.sif
printf "1500 1800\n" >> bolus.sif
printf "1800 2100\n" >> bolus.sif
printf "2100 2400\n" >> bolus.sif
printf "2400 2700\n" >> bolus.sif
printf "2700 3000\n" >> bolus.sif
printf "3000 3600\n" >> bolus.sif
printf "3600 4200\n" >> bolus.sif
printf "4200 4800\n" >> bolus.sif
printf "4800 5400\n" >> bolus.sif
fi

if [ ! -f r1tcm.bld ] || [ ! -f r1tcm.tac ] || [ ! -f r1tcm_yokoi.par ] || [ ! -f bolus.bld ]; then
  printf "FIT1        General\n" > r1tcm.fit
  printf "Date:	\n" >> r1tcm.fit
  printf "Data file:	\n" >> r1tcm.fit
  printf "Data unit:	kBq/mL\n" >> r1tcm.fit
  printf "Time unit:	min\n" >> r1tcm.fit
  printf "Nr of VOIs:	3\n" >> r1tcm.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> r1tcm.fit
  printf "Input	0.000	60.000	100	0	4	1833	100	0.75	0.04	0.5\n" >> r1tcm.fit
  printf "K1	0.000	60.000	100	0	1	100	0.20\n" >> r1tcm.fit
  printf "k2	0.000	60.000	100	0	1	100	0.10\n" >> r1tcm.fit

  fit2dat -c=0,90,0.05 r1tcm.fit r1tcm.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  tacadd -ovr bolus.bld r1tcm.bld 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg bolus.svg -l bolus.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  simframe r1tcm.bld bolus.sif r1tcm.tac
  printf "\n ok \n"

  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	K1/k2\n" > r1tcm_yokoi.par
  printf "Ct	0.2	0.1	2\n" >> r1tcm_yokoi.par
fi


if [ ! -f i1tcm.bld ] || [ ! -f i1tcm.tac ] || [ ! -f i1tcm_patlak.par ]; then
  printf "FIT1        General\n" > i1tcm.fit
  printf "Date:	\n" >> i1tcm.fit
  printf "Data file:	\n" >> i1tcm.fit
  printf "Data unit:	kBq/mL\n" >> i1tcm.fit
  printf "Time unit:	min\n" >> i1tcm.fit
  printf "Nr of VOIs:	2\n" >> i1tcm.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> i1tcm.fit
  printf "Input	0.000	60.000	100	0	4	1833	100	0.75	0.04	0.5\n" >> i1tcm.fit
  printf "K1	0.000	60.000	100	0	1	100	0.05\n" >> i1tcm.fit

  fit2dat -c=0,90,0.05 i1tcm.fit i1tcm.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe i1tcm.bld bolus.sif i1tcm.tac
  printf "\n ok \n"

  printf "Parameters	Ki[mL/(mL*min)]	Ic[mL/mL]	r[unitless]\n" > i1tcm_patlak.par
  printf "Ct	0.05	0	1\n" >> i1tcm_patlak.par
fi


if [ ! -f i2tcm.bld ] || [ ! -f i2tcm.tac ] || [ ! -f i2tcm_patlak.par ]; then
  printf "FIT1        General\n" > i2tcm.fit
  printf "Date:	\n" >> i2tcm.fit
  printf "Data file:	\n" >> i2tcm.fit
  printf "Data unit:	kBq/mL\n" >> i2tcm.fit
  printf "Time unit:	min\n" >> i2tcm.fit
  printf "Nr of VOIs:	4\n" >> i2tcm.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> i2tcm.fit
  printf "Input	0.000	60.000	100	0	4	1833	100	0.75	0.04	0.5\n" >> i2tcm.fit
  printf "K1	0.000	60.000	100	0	1	100	0.10\n" >> i2tcm.fit
  printf "k2	0.000	60.000	100	0	1	100	0.20\n" >> i2tcm.fit
  printf "k3	0.000	60.000	100	0	1	100	0.05\n" >> i2tcm.fit

  fit2dat -c=0,90,0.05 i2tcm.fit i2tcm.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe i2tcm.bld bolus.sif i2tcm.tac
  printf "\n ok \n"

  printf "Parameters	Ki[mL/(mL*min)]	Ic[mL/mL]	r[unitless]\n" > i2tcm_patlak.par
  printf "Ct	0.02	0.32	1\n" >> i2tcm_patlak.par
fi


if [ ! -f r2tcm.bld ] || [ ! -f r2tcm.tac ] || [ ! -f r2tcm_logan.par ]; then
  printf "FIT1        General\n" > r2tcm.fit
  printf "Date:	\n" >> r2tcm.fit
  printf "Data file:	\n" >> r2tcm.fit
  printf "Data unit:	kBq/mL\n" >> r2tcm.fit
  printf "Time unit:	min\n" >> r2tcm.fit
  printf "Nr of VOIs:	5\n" >> r2tcm.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> r2tcm.fit
  printf "Input	0.000	60.000	100	0	4	1833	100	0.75	0.04	0.5\n" >> r2tcm.fit
  printf "K1	0.000	60.000	100	0	1	100	0.20\n" >> r2tcm.fit
  printf "k2	0.000	60.000	100	0	1	100	0.40\n" >> r2tcm.fit
  printf "k3	0.000	60.000	100	0	1	100	0.30\n" >> r2tcm.fit
  printf "k4	0.000	60.000	100	0	1	100	0.20\n" >> r2tcm.fit

  fit2dat -c=0,90,0.05 r2tcm.fit r2tcm.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe r2tcm.bld bolus.sif r2tcm.tac
  printf "\n ok \n"

  printf "Parameters	DV[mL/mL]	Ic[1/min]	r[unitless]\n" > r2tcm_logan.par
  printf "Ct	1.25	-9.25	1\n" >> r2tcm_logan.par

fi


if [ ! -f step.bld ]; then
  printf "FIT1        General\n" > step.fit
  printf "Date:	\n" >> step.fit
  printf "Data file:	\n" >> step.fit
  printf "Data unit:	kBq/mL\n" >> step.fit
  printf "Time unit:	min\n" >> step.fit
  printf "Nr of VOIs:	5\n" >> step.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> step.fit
  printf "Input	0.000	60.000	100	0	4	1833	100	0.75	0.04	0.5\n" >> step.fit
  printf "K1	0.000	60.000	100	0	1	100	0.30\n" >> step.fit
  printf "k2	0.000	60.000	100	0	1	100	0.60\n" >> step.fit
  printf "k3	0.000	60.000	100	0	4	1010	0	0.40	50	0.50\n" >> step.fit
  printf "k4	0.000	60.000	100	0	4	1010	0	0.20	50	0.50\n" >> step.fit

  fit2dat -c=0,90,0.05 step.fit step.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: R1TCM. \n"
printf " Test case 2: frequent samples (x). \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o100.dat

$PROGRAM r1tcm.bld o100.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o100.svg -l bolus.bld o100.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n r1tcm.bld o100.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

yokoi -svg=y100.svg o100.dat bolus.bld 15 90 y100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=0.1 r1tcm_yokoi.par y100.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: R1TCM. \n"
printf " Test case 2: framed data (x1 and x2). \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o110.tac

$PROGRAM r1tcm.tac o110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o110.svg -l bolus.bld o100.dat -b o110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n r1tcm.tac o110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

yokoi -svg=y110.svg o110.tac bolus.bld 15 90 y110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=1 r1tcm_yokoi.par y110.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: R1TCM. \n"
printf " Test case 2: framed data (x1 and x2). \n"
printf " Test case 3: Option -fe to save frame end times. \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o111.dat stdout.txt

$PROGRAM -fe r1tcm.tac o111.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o111.svg -l bolus.bld o100.dat -b o111.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacrange o111.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

yokoi -svg=y111.svg o111.dat bolus.bld 15 90 y111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -rel=0.1 r1tcm_yokoi.par y111.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: i1TCM. \n"
printf " Test case 2: frequent samples (x). \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o200.dat

$PROGRAM i1tcm.bld o200.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o200.svg -l bolus.bld o200.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n i1tcm.bld o200.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

patlak -sd=no o200.dat bolus.bld 15 90 p200.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK p200.res p200.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -rel=0.1 -abs=0.00001 i1tcm_patlak.par p200.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: i1TCM. \n"
printf " Test case 2: framed data (x1 and x2). \n"
printf " Test case 3: Option -fe to save frame end times. \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o201.dat stdout.txt

$PROGRAM -fe i1tcm.tac o201.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o201.svg -l bolus.bld o200.dat -b o201.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacrange o201.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

patlak -sd=no -svg=p201.svg o201.dat bolus.bld 15 90 p201.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK p201.res p201.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -rel=0.1 -abs=0.00001 i1tcm_patlak.par p201.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case 1: i2TCM. \n"
printf " Test case 2: frequent samples (x). \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o300.dat

$PROGRAM i2tcm.bld o300.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o300.svg -l bolus.bld o300.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n i2tcm.bld o300.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

patlak -sd=no o300.dat bolus.bld 30 90 p300.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK p300.res p300.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -par=1,3 -rel=0.1 -abs=0.0001 i2tcm_patlak.par p300.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -rel=10 i2tcm_patlak.par p300.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case 1: i2TCM. \n"
printf " Test case 2: framed data (x1 and x2). \n"
printf " Test case 3: Option -fe to save frame end times. \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o301.dat stdout.txt

$PROGRAM -fe i2tcm.tac o301.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o301.svg -l bolus.bld o300.dat -b o301.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacrange o301.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

patlak -sd=no -svg=p301.svg o301.dat bolus.bld 30 90 p301.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK p301.res p301.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -par=1,3 -rel=0.1 -abs=0.0001 i2tcm_patlak.par p301.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -rel=10 i2tcm_patlak.par p301.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case: Save also compartmental TACs. \n"
printf " Expected result: Compartmental TACs saved. \n\n"

rm -f o310.dat

$PROGRAM -sub i2tcm.bld o310.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o310.svg -l bolus.bld o310.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacadd -ovr temp.dat o310.dat Ct
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp1.dat o310.dat C1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp2.dat o310.dat C2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc temp1.dat + temp2.dat sum.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.1 temp.dat sum.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 4.0.0 \n"
printf " Test case 1: r2TCM. \n"
printf " Test case 2: frequent samples (x). \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o400.dat

$PROGRAM r2tcm.bld o400.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o400.svg -l bolus.bld o400.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

logan -c -sd=no -svg=l400.svg o400.dat bolus.bld 30 90 l400.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK l400.res l400.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -par=1,3 -rel=0.1 -abs=0.0001 r2tcm_logan.par l400.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -rel=5 r2tcm_logan.par l400.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

yokoi -svg=y400a.svg o400.dat bolus.bld 0 1 y400a.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT y400a.par y400a.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 y400a.ift K1 0.20
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.02 y400a.ift k2 0.40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

yokoi -svg=y400b.svg o400.dat bolus.bld 80 90 y400b.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=IFT y400b.par y400b.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 y400b.ift K1/k2 1.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 \n"
printf " Test case 1: r2TCM. \n"
printf " Test case 2: framed data (x1 and x2). \n"
printf " Test case 3: Option -fe to save frame end times. \n"
printf " Expected result: Correct TAC simulated. \n\n"

rm -f o401.dat stdout.txt

$PROGRAM -fe r2tcm.tac o401.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o401.svg -l bolus.bld o400.dat -b o401.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacrange o401.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt time_max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

logan -c -sd=no -svg=l401.svg o401.dat bolus.bld 30 90 l401.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parformat -f=TSV-UK l401.res l401.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
parmatch -par=1,3 -rel=0.1 -abs=0.0001 r2tcm_logan.par l401.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -par=2 -rel=5 r2tcm_logan.par l401.par
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 4.1.0 \n"
printf " Test case 1: Stepwise change in k3 and k4. \n"
printf " Test case 2: Frequent samples (x). \n"
printf " Expected result: Correct TBRs reached. \n\n"


rm -f o410.dat

$PROGRAM step.bld o410.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg o410.svg -l bolus.bld o410.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taccalc o410.dat div bolus.bld temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -x=50,90 temp.dat ratio.dat
taclist -ift ratio.dat > ratio.ift
iftisval -abs=0.02 ratio.ift value[1][1] 1.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 ratio.ift value[1][2] 1.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




rm -f *.bak
printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

