#!/bin/bash
#: Title      : test_fit_suri
#: Date       : 2023-02-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_suri$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f suri.fit ] || [ ! -f limits.ift ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f ua1435.tac ] || [ ! -f ua1435.lim ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

if [ ! -f btac1.bld ]; then
  fit2dat -a=30 suri.fit btac1.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi





printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Fit simulated TAC. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output100.svg output100.fit
$PROGRAM -lim=limits.ift -svg=output100.svg btac1.bld output100.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output100.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=btac1.bld output100.fit output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=3 btac1.bld output.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Fit real tissue TACs. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output200.svg output200.fit
$PROGRAM -lim=ua1435.lim -svg=output200.svg ua1435.tac output200.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output200.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=ua1435.tac output200.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=3 -rel=5 ua1435.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

