#!/bin/bash
#: Title      : test_fit_wcdf
#: Date       : 2019-10-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_wcdf$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f wcdfd.fit ] || [ ! -f wcdf.fit ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f ua1435.tac ] || [ ! -f ua1435.lim ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi

if [ ! -f wcdfd.tac ]; then
  fit2dat -a=30 wcdfd.fit wcdfd.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f wcdf.tac ]; then
  fit2dat -a=30 wcdf.fit wcdf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Fit simulated TAC with default options. \n"
printf " Test case 2: Delay time fixed. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_wcdfd.svg output_wcdfd.fit
$PROGRAM -dt=2 -svg=output_wcdfd.svg wcdfd.tac output_wcdfd.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_wcdfd.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=wcdfd.tac output_wcdfd.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=3 wcdfd.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Fit simulated CDF TAC with otherwise default options. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_wcdf.svg output_wcdf.fit
$PROGRAM -cdf -svg=output_wcdf.svg wcdf.tac output_wcdf.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_wcdf.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f=wcdf.tac output_wcdf.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=3 wcdf.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Fit real PET TTAC data. \n"
printf " Test case 2: Parameter limits from file. \n"
printf " Test case 3: Option -wf. \n"
printf " Expected result: reasonable fit is obtained. \n\n"

rm -f output_ua1435.svg output_ua1435.fit
$PROGRAM -wf -lim=ua1435.lim -svg=output_ua1435.svg ua1435.tac output_ua1435.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output_ua1435.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccut ua1435.tac 3.5 70 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fit2dat -f=test.tac output_ua1435.fit output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=2 test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

