#!/bin/bash
#: Title      : test_tacmean
#: Date       : 2021-10-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacmean$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


if [ ! -f tissue1.tac ] || [ ! -f correct_mean1.tac ]; then
  printf "\nData for non-weighted means\n"
  printf "start[seconds]\tend[kBq/cc]\tvoi1_mean\tvoi2_mean\trefer\n" > tissue1.tac
  printf "0.0\t30.0\t3.0e+000\t2.0e+000\t1.0e+000\n" >> tissue1.tac
  printf "30.0\t60.0\t1.3e+002\t8.0e+001\t3.0e+001\n" >> tissue1.tac
  printf "60.0\t120.0\t4.0e+001\t3.0e+001\t5.0e+001\n" >> tissue1.tac
  printf "120.0\t360.0\t2.0e+002\t3.0e+002\t1.0e+002\n" >> tissue1.tac

  printf "start[seconds]\tend[kBq/cc]\tMean\n" > correct_mean1.tac
  printf "0.0\t30.0\t2.0e+000\n" >> correct_mean1.tac
  printf "30.0\t60.0\t8.0e+001\n" >> correct_mean1.tac
  printf "60.0\t120.0\t4.0e+001\n" >> correct_mean1.tac
  printf "120.0\t360.0\t2.0e+002\n" >> correct_mean1.tac
fi

if [ ! -f correct_sd1.tac ] || [ ! -f correct_cv1.tac ]; then
  printf "start[seconds]\tend[kBq/cc]\tSD\n" > correct_sd1.tac
  printf "0.0\t30.0\t1.0e+000\n" >> correct_sd1.tac
  printf "30.0\t60.0\t5.0e+001\n" >> correct_sd1.tac
  printf "60.0\t120.0\t1.0e+001\n" >> correct_sd1.tac
  printf "120.0\t360.0\t1.0e+002\n" >> correct_sd1.tac

  printf "start[seconds]\tend[unitless]\tCV\n" > correct_cv1.tac
  printf "0.0\t30.0\t5.0e-001\n" >> correct_cv1.tac
  printf "30.0\t60.0\t6.25e-001\n" >> correct_cv1.tac
  printf "60.0\t120.0\t2.5e-001\n" >> correct_cv1.tac
  printf "120.0\t360.0\t5.0e-001\n" >> correct_cv1.tac
fi

if [ ! -f tissue2.dft ] || [ ! -f tissue2.par ] || [ ! -f correct_mean2.dft ]; then
  printf "\nData for weighted means\n"
  printf "DFT1\tvoi1\tvoi2\trefer\n" > tissue2.dft
  printf "tissue1\tmean\tmean\t.\n" >> tissue2.dft
  printf "kBq/mL\tAll\tAll\tAll\n" >> tissue2.dft
  printf "Times (sec)\t1.1e+001\t9.0e+000\t8.0e+001\n" >> tissue2.dft
  printf "0.0\t30.0\t3.0e+000\t2.0e+000\t1.0e+000\n" >> tissue2.dft
  printf "30.0\t60.0\t5.0e+002\t8.0e+001\t3.0e+001\n" >> tissue2.dft
  printf "60.0\t120.0\t2.0e+002\t4.0e+001\t5.0e+001\n" >> tissue2.dft
  printf "120.0\t360.0\t2.0e+002\t4.0e+001\t2.0e+001\n" >> tissue2.dft

  printf "parameters\tP1\tWeight\n" > tissue2.par
  printf "voi1\t1.0\t110\n" >> tissue2.par
  printf "voi2\t1.0\t90\n" >> tissue2.par
  printf "refer\t1.0\t800\n" >> tissue2.par

  printf "DFT1                 Mean\n" > correct_mean2.dft
  printf "test1                .\n" >> correct_mean2.dft
  printf "kBq/ml               .\n" >> correct_mean2.dft
  printf "Times (sec)           1.000e+002\n" >> correct_mean2.dft
  printf "    0.0000   30.0000  1.310e+000\n" >> correct_mean2.dft
  printf "   30.0000   60.0000  8.620e+001\n" >> correct_mean2.dft
  printf "   60.0000  120.0000  6.560e+001\n" >> correct_mean2.dft
  printf "  120.0000  360.0000  4.160e+001\n" >> correct_mean2.dft
fi

if [ ! -f tissue2b.par ] || [ ! -f correct_mean2b.dft ]; then
  printf "parameters\tP1\n" > tissue2b.par
  printf "voi1\t0.0\n" >> tissue2b.par
  printf "voi2\t0.0\n" >> tissue2b.par
  printf "refer\t1.0\n" >> tissue2b.par

  printf "DFT1                 Mean\n" > correct_mean2b.dft
  printf "test1                .\n" >> correct_mean2b.dft
  printf "kBq/ml               .\n" >> correct_mean2b.dft
  printf "Times (sec)           8.000e+001\n" >> correct_mean2b.dft
  printf "    0.0000   30.0000  1.0e+000\n" >> correct_mean2b.dft
  printf "   30.0000   60.0000  3.0e+001\n" >> correct_mean2b.dft
  printf "   60.0000  120.0000  5.0e+001\n" >> correct_mean2b.dft
  printf "  120.0000  360.0000  2.0e+001\n" >> correct_mean2b.dft
fi

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Default settings. \n"
printf " Expected result: Correct non-weighted means saved. \n\n"

rm -f output.tac

$PROGRAM tissue1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.1 \n"
printf " Test case: Output file is the same as input file. \n"
printf " Expected result: Mean curve saved in input file. \n\n"

cp -f tissue1.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.tac

$PROGRAM test.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr output.tac test.tac 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.1.0 \n"
printf " Test case: Save mean and with option the SD. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.tac output_sd.tac

$PROGRAM -sd=output_sd.tac tissue1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_sd1.tac output_sd.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.0 \n"
printf " Test case: Save mean and with option the CV. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.tac output_cv.tac

$PROGRAM -cv=output_cv.tac tissue1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_cv1.tac output_cv.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.3.0 \n"
printf " Test case: Save SD and CV with options, but do not save mean TAC. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.tac output_sd.tac output_cv.tac

$PROGRAM -sd=output_sd.tac -cv=output_cv.tac tissue1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_sd1.tac output_sd.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_cv1.tac output_cv.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.3.1 \n"
printf " Test case: Save SD and CV with options, and add mean TAC to input file. \n"
printf " Expected result: Correct data saved. \n\n"

cp -f tissue1.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.tac output_sd.tac output_cv.tac

$PROGRAM -sd=output_sd.tac -cv=output_cv.tac test.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr output.tac test.tac 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_sd1.tac output_sd.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_cv1.tac output_cv.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.4.0 \n"
printf " Test case: Use option -ws when data does not contain sizes.\n"
printf " Expected result: Error. \n\n"

rm -f output.tac stdout.txt

$PROGRAM -ws tissue1.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "Data does not contain ROI sizes."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.4.1 \n"
printf " Test case: Use option -ws when computing SD or CV.\n"
printf " Expected result: Error. \n\n"

rm -f output.dft stdout.txt

$PROGRAM -ws -sd=output_sd.dft tissue2.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "SD and CV cannot be computed with TAC weighting."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.dft stdout.txt

$PROGRAM -ws -cv=output_cv.dft tissue2.dft output.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "SD and CV cannot be computed with TAC weighting."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.4.2 \n"
printf " Test case: Calculate weighted mean TAC using option -ws. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.dft

$PROGRAM -ws tissue2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.4.3 \n"
printf " Test case: Calculate weighted mean TAC into input file using option -ws. \n"
printf " Expected result: Correct data saved. \n\n"

cp -f tissue2.dft test.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
rm -f output.dft

$PROGRAM -ws test.dft test.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr output.dft test.dft 4
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.5.0 \n"
printf " Test case: Calculate weighted mean TAC using weights from parameter file. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.dft

$PROGRAM -wf=tissue2.par tissue2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.5.1 \n"
printf " Test case: Only one of TACs gets weight in parameter file. \n"
printf " Expected result: Correct data saved. \n\n"

rm -f output.dft

$PROGRAM -wf=tissue2b.par tissue2.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=0.01 correct_mean2b.dft output.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.6.0 \n"
printf " Test case: None of output file names given. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM tissue2.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "Missing output filename."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -ws tissue2.dft &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "Missing output filename."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
