#!/bin/bash
#: Title      : test_tac2xml
#: Date       : 2020-01-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None
#: Note       : Results not tested because reading output file not supported.

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tac2xml$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"


if [ ! -f data1.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data1.tac
  printf "2.0    7.0                3.0    2.0     1.0\n"    >> data1.tac
  printf "230.0  260.0              9.0    8.0     7.0\n"    >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data2.tac ]; then
  printf "start[seconds] end[bq/cc] Makara  Nakki  Aladobi\n" > data2.tac
  printf "8.0    12.0                3.0    4.0     2.0\n"   >> data2.tac
  printf "12.0   26.0                4.0    5.0     3.0\n"   >> data2.tac
  printf "27.0   37.0                5.0    6.0     4.0\n"   >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: Two files, no options. \n"
printf " Expected result: No error. \n\n"

rm -f output100.xml

$PROGRAM output100.xml data?.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.1 \n"
printf " Test case: Two files, saving frame mid times. \n"
printf " Expected result: No error. \n\n"

rm -f output101.xml

$PROGRAM -mid output101.xml data?.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.2 \n"
printf " Test case: One file, no options. \n"
printf " Expected result: No error. \n\n"

rm -f output102.xml

$PROGRAM output102.xml data2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
