#!/bin/bash
#: Title      : test_tacadd
#: Date       : 2020-01-23
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacadd$EXT;

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n\n 0.1.0 \n"
printf " Test case: Nonexisting argument file. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d nonexistingfile1.tac nonexistingfile2.tac
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d nonexistingfile1.tac tacadd.dft tacadd.dft nonexistingfile4.tac
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n\n 0.2.0 \n"
printf " Test case: Binary file as argument file. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d temp.dat $PROGRAM
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n\n 0.3.0 \n"
printf " Test case: Missing argument file. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d temp.dat
if [ $? -eq 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n\n 1.0.0 \n"
printf " Test case: Add all TACs from one file to a non-existing file. \n"
printf " Expected result: Correct output. \n\n"

rm -f test.dft

$PROGRAM test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n\n 1.0.1 \n"
printf " Test case: Option -ovr. \n"
printf " Expected result: Correct output. \n\n"

$PROGRAM -ovr test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"

printf "\n\n 1.0.2 \n"
printf " Test case: Add all TACs from one file to an existing file. \n"
printf " Expected result: Correct output. \n\n"

$PROGRAM test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacdel test.dft 1 2 3
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n\n 1.2.0 \n"
printf " Test case: Add certain TAC (by number) to a non-existing file. \n"
printf " Expected result: Correct output. \n\n"

rm -f test.dft test2.dft
cp -f tacadd.dft test2.dft 
tacdel test2.dft 1 3
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

$PROGRAM -ovr test.dft tacadd.dft 2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test2.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n\n 1.3.0 \n"
printf " Test case: Add certain TAC (by name) to a non-existing file. \n"
printf " Expected result: Correct output. \n\n"

rm -f test.dft test2.dft
cp -f tacadd.dft test2.dft 
tacdel test2.dft 1 2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

$PROGRAM -ovr test.dft tacadd.dft head
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test2.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n\n 1.3.1 \n"
printf " Test case: Add certain TACs, specified by initial part of name. \n"
printf " Expected result: Correct output. \n\n"

rm -f test.dft test2.dft
cp -f tacadd.dft test2.dft 
tacdel --silent test2.dft 3
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

$PROGRAM -ovr -namestart test.dft tacadd.dft voi
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test2.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n\n 1.4.0 \n"
printf " Test case: Move certain TAC (by name) to a non-existing file. \n"
printf " Expected result: Correct new file and modified source file. \n\n"

rm -f test.dft test2.dft
cp -f tacadd.dft test2.dft 
tacdel test2.dft 1 2
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
cp -f tacadd.dft temp.dft 
cp -f tacadd.dft test3.dft 
tacdel test3.dft head
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi

$PROGRAM -ovr -move test.dft temp.dft head
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test2.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 test3.dft temp.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n\n 2.0.0 \n"
printf " Test case: Add TACs from two files to a non-existing file. \n"
printf " Expected result: Correct output. \n\n"

taccalc tacadd.dft x 2 temp.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
rm -f test.dft

$PROGRAM test.dft temp.dft tacadd.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacdel test.dft 1 2 3
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 tacadd.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"


printf "\n\n 2.0.1 \n"
printf " Test case: Add TACs from three files to an existing file. \n"
printf " Expected result: Correct output. \n\n"

$PROGRAM test.dft temp.dft tacadd.dft temp.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacdel test.dft 1 2 3 4 5 6 10 11 12
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.00001 tacadd.dft test.dft
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "passed.\n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
