#!/bin/bash
#: Title      : test_tacadd0
#: Date       : 2021-11-08
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacadd0$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f data1.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data1.tac
  printf "3.0    4.0                3.0    2.0     1.0\n" >> data1.tac
  printf "4.0    5.0                9.0    8.0     7.0\n" >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct1a.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > correct1a.tac
  printf "2.0    3.0                0.0    0.0     0.0\n" >> correct1a.tac
  printf "3.0    4.0                3.0    2.0     1.0\n" >> correct1a.tac
  printf "4.0    5.0                9.0    8.0     7.0\n" >> correct1a.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct1b.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > correct1b.tac
  printf "2.5           0.0    0.0     0.0\n" >> correct1b.tac
  printf "3.5           3.0    2.0     1.0\n" >> correct1b.tac
  printf "4.5           9.0    8.0     7.0\n" >> correct1b.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct1xa.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > correct1xa.tac
  printf "3.0    4.0                3.0    2.0     1.0\n" >> correct1xa.tac
  printf "4.0    5.0                9.0    8.0     7.0\n" >> correct1xa.tac
  printf "5.0    6.0                0.0    0.0     0.0\n" >> correct1xa.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct1xb.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > correct1xb.tac
  printf "3.5           3.0    2.0     1.0\n" >> correct1xb.tac
  printf "4.5           9.0    8.0     7.0\n" >> correct1xb.tac
  printf "5.5           0.0    0.0     0.0\n" >> correct1xb.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


if [ ! -f data2.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data2.tac
  printf "1000.0 2000.0             4.0    3.0     2.0\n" >> data2.tac
  printf "2.0    7.0                3.0    2.0     1.0\n" >> data2.tac
  printf "230.0  260.0              9.0    8.0     7.0\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct2a.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > correct2a.tac
  printf "0.0    2.0                0.0    0.0     0.0\n" >> correct2a.tac
  printf "2.0    7.0                3.0    2.0     1.0\n" >> correct2a.tac
  printf "230.0  260.0              9.0    8.0     7.0\n" >> correct2a.tac
  printf "1000.0 2000.0             4.0    3.0     2.0\n" >> correct2a.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct2b.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > correct2b.tac
  printf "0.0           0.0    0.0     0.0\n" >> correct2b.tac
  printf "4.5           3.0    2.0     1.0\n" >> correct2b.tac
  printf "245.0         9.0    8.0     7.0\n" >> correct2b.tac
  printf "1500.0        4.0    3.0     2.0\n" >> correct2b.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data3.tac
  printf "3.0    4.0                3.0    2.0     1.0\n" >> data3.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct3a.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > correct3a.tac
  printf "2.0    3.0                0.0    0.0     0.0\n" >> correct3a.tac
  printf "3.0    4.0                3.0    2.0     1.0\n" >> correct3a.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct3b.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > correct3b.tac
  printf "0.0           0.0    0.0     0.0\n" >> correct3b.tac
  printf "3.5           3.0    2.0     1.0\n" >> correct3b.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data4.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data4.tac
  printf "2.0    7.0                3.0    2.0     1.0\n" >> data4.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct4a.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > correct4a.tac
  printf "0.0    2.0                0.0    0.0     0.0\n" >> correct4a.tac
  printf "2.0    7.0                3.0    2.0     1.0\n" >> correct4a.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f correct4b.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > correct4b.tac
  printf "0.0           0.0    0.0     0.0\n" >> correct4b.tac
  printf "4.5           3.0    2.0     1.0\n" >> correct4b.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data5.tac ]; then
  printf "start[seconds] end[bq/cc] Nakki  Makara  Aladobi\n" > data5.tac
  printf "0.0    5.0                3.0    2.0     1.0\n" >> data5.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi
if [ ! -f data5b.tac ]; then
  printf "time[seconds] Nakki  Makara  Aladobi\n" > data5b.tac
  printf "0.0           3.0    2.0     1.0\n" >> data5b.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case 1: Long gap in the beginning. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.tac

$PROGRAM data1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct1a.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.0.1 \n"
printf " Test case 1: Long gap in the beginning. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Expected result: Correct output file. \n\n"

tacformat -mid -f=pmod data1.tac temp.tac
rm -f output.tac

$PROGRAM temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct1b.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n\n 1.1.0 \n"
printf " Test case 1: Short gap in the beginning. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Test case 3: Data needs sorting. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.tac

$PROGRAM data2.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct2a.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.1 \n"
printf " Test case 1: Short gap in the beginning. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Test case 3: Data needs sorting. \n"
printf " Expected result: Correct output file. \n\n"

tacformat -mid -f=pmod data2.tac temp.tac
rm -f output.tac

$PROGRAM temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct2b.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n\n 1.2.0 \n"
printf " Test case 1: Long gap in the beginning. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Test case 3: Originally only one sample. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.tac

$PROGRAM data3.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct3a.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.1 \n"
printf " Test case 1: Long gap in the beginning. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Test case 3: Originally only one sample. \n"
printf " Expected result: Correct output file. \n\n"

tacformat -mid -f=pmod data3.tac temp.tac
rm -f output.tac

$PROGRAM temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct3b.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n\n 1.3.0 \n"
printf " Test case 1: Short gap in the beginning. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Test case 3: Originally only one sample. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.tac

$PROGRAM data4.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct4a.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.3.1 \n"
printf " Test case 1: Short gap in the beginning. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Test case 3: Originally only one sample. \n"
printf " Expected result: Correct output file. \n\n"

tacformat -mid -f=pmod data4.tac temp.tac
rm -f output.tac

$PROGRAM temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct4b.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"
printf "\n\n 1.4.0 \n"
printf " Test case 1: No gap in the beginning. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Expected result: No error, no file written. \n\n"

rm -f output.tac

$PROGRAM data5.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.4.1 \n"
printf " Test case 1: No gap in the beginning. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Expected result: No error, no file written. \n\n"

rm -f output.tac

$PROGRAM data5b.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n=====================================================================\n"
printf "\n 2.0.0 \n"
printf " Test case 1: Option -x with valid value. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Expected result: Correct output file. \n\n"

rm -f output.tac

$PROGRAM -x=5.5 data1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct1xa.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case 1: Option -x with valid value. \n"
printf " Test case 2: Frame mid time available. \n"
printf " Expected result: Correct output file. \n\n"

tacformat -mid -f=pmod data1.tac temp.tac
rm -f output.tac

$PROGRAM -x=5.5 temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct1xb.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n\n 2.1.0 \n"
printf " Test case 1: Option -x with value before data ends. \n"
printf " Test case 2: Frame start and end times available. \n"
printf " Expected result: No error, no file written. \n\n"

rm -f output.tac

$PROGRAM -x=4.9 data1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

cp -f data1.tac temp.tac
$PROGRAM -x=4.9 temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 2.1.1 \n"
printf " Test case 1: Option -x with value before data ends. \n"
printf " Test case 2: Frame mid times available. \n"
printf " Expected result: No error, no file written. \n\n"

tacformat -mid -f=pmod data1.tac temp.tac
rm -f output.tac

$PROGRAM -x=4.5 temp.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
