#!/bin/bash
#: Title      : test_taccalc
#: Date       : 2023-04-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../taccalc$EXT;

printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0\n"

printf "\nNonexisting argument file 1 should give an error\n"
$PROGRAM -d nonexistingfile.tac x 2 output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\npassed.\n\n"

printf "Nonexisting argument file 2 should give an error\n"
$PROGRAM -d calc1.dft + nonexistingfile.tac output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.1.1\n"

printf "\nInvalid operation should give an error\n"
$PROGRAM -d calc1.dft m 2 output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.2.0\n"

printf "\nMissing CLI argument should give an error\n"
$PROGRAM -d calc1.dft 2 output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

$PROGRAM -d x 2 output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.3.0\n"

printf "\nExtra CLI argument should give an error\n"
$PROGRAM -d calc1.dft x 2 output.tac extra
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.3.1\n"

printf "\nInvalid option should give an error\n"
$PROGRAM -stupidoption calc1.dft x 2 output.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n0.4.0\n"

printf "\nBinary file as argument file should not crash program\n"
$PROGRAM -d $PROGRAM x 2 output.dft
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "passed.\n\n"

printf "\n===================================================================\n"
printf "\n   operations with constant value  \n"
printf "\n===================================================================\n"

printf "\n1.0.0\n"

printf "\n Multiply \n"

rm -f output.dft
$PROGRAM -d calc1.dft x 2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.dft
$PROGRAM -d calc1.dft . 2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.0.1\n"

printf "\n Multiply with negative constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft x -2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1n.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"


printf "\n1.1.0\n"

printf "\n Add positive constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft + 2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.1.1\n"

printf "\n Add negative constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft + -2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"


printf "\n1.2.0\n"

printf "\n Subtract positive constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft - 2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.2.1\n"

printf "\n Subtract negative constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft - -2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"


printf "\n1.3.0\n"

printf "\n Divide by positive constant \n"

rm -f output.dft
$PROGRAM -d calc1.dft : 2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1d.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.3.1\n"

printf "\n Divide by negative constant \n"

rm -f output.dft
$PROGRAM -d5 calc1.dft : -2 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
$PROGRAM -d calc1.dft x -0.5 temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 temp.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n1.3.2\n"

printf "\n Divide by decimal constant, with decimal comma \n"

rm -f output.dft
$PROGRAM -d calc1.dft div 0,5 output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc1a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "\n   operations between TAC files  \n"
printf "\n===================================================================\n"


printf "\n2.0.0\n"

printf "\n Substract file from itself \n\n"

rm -f output.dft temp.dft
$PROGRAM calc1.dft x 0 temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
$PROGRAM -d calc1.dft - calc1.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 temp.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.1\n"

printf "\n Substract. Same TAC nr, different sample nr \n\n"

rm -f output.dft stdout.txt
$PROGRAM calc1.dft - calc2.dft output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc2a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt Warning "check the time ranges."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.0\n"

printf "\n Division. Same TAC nr, different sample nr \n\n"

rm -f output.dft
$PROGRAM -d calc1.dft : calc2.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.5 calc2b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"


printf "\n2.2.0\n"

printf "\n Sum. Different TAC nr, different sample nr \n\n"

rm -f output.dft
$PROGRAM -d1 calc1.dft + calc3.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc2c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.2.1\n"

printf "\n Multiplication. Different TAC nr, different sample nr \n\n"

rm -f output.dft
$PROGRAM -d4 calc1.dft X calc3.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc2d.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "\n   operations with constant value given as single sample in file   \n"
printf "\n===================================================================\n"


printf "\n3.0.0\n"

printf "\n Subtraction \n\n"
printf "\n ... different units, therefore --force \n\n"

rm -f output.dft
$PROGRAM --force calc1.dft - calc4.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc4a.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.0.1\n"

printf "\n Division \n\n"
printf "\n ... different units, therefore --force \n\n"

rm -f output.dft
$PROGRAM -f calc1.dft : calc4.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc4b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.0.2\n"

printf "\n Sum \n\n"
printf "\n ... different units, therefore --force \n\n"

rm -f output.dft
$PROGRAM --force calc1.dft + calc4.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc4c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.0.3\n"

printf "\n Multiply \n\n"
printf "\n ... different units, therefore --force \n\n"

rm -f output.dft
$PROGRAM -f calc1.dft x calc4.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc4d.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n3.0.4\n"

printf "\n Same result with very simple constant file \n\n"

rm -f temp.dft output.dft
printf "0 2\n" > temp.dft
$PROGRAM --force calc1.dft x temp.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -abs=0.01 -rel=0.2 calc4d.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "\n   Files have different time units \n"
printf "\n===================================================================\n"

tacformat -f=pmod calc1.dft calc1_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacformat -f=pmod calc2.dft calc2_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=sec -yset=kBq/cc calc1_s.tac calc2_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc1_s.tac calc1_m.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc2_s.tac calc2_m.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min calc1_m.tac calc2_m.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

tacformat -f=pmod calc2a.dft calc2a_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=sec -yset=kBq/cc calc2a_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc2a_s.tac calc2a_m.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min calc2a_m.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n4.0.0\n"

printf "\n Times are actually the same, but in different units \n\n"

rm -f output.tac
$PROGRAM calc1_m.tac - calc2_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_m.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac
$PROGRAM calc1_s.tac - calc2_m.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.0.1\n"

printf "\n Option --force has no effect in this case \n\n"

rm -f output.tac
$PROGRAM --force calc1_m.tac - calc2_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_m.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac
$PROGRAM --force calc1_s.tac - calc2_m.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n4.1.0\n"

cp -f calc1_s.tac calc1_u.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc2_s.tac calc2_u.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xset=unknown calc1_u.tac calc2_u.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n One of files has unknown time units \n\n"

printf "\n Error will be printed \n\n"

rm -f output.tac stdout.txt
$PROGRAM calc1_u.tac - calc2_s.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt Error "incompatible units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac stdout.txt
$PROGRAM calc1_s.tac - calc2_u.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt Error "incompatible units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n With option --force ok \n\n"

rm -f output.tac stdout.txt
$PROGRAM -f calc1_u.tac - calc2_s.tac output.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac stdout.txt
$PROGRAM -f calc1_s.tac - calc2_u.tac output.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "\n   Files have different conc units \n"
printf "\n===================================================================\n"

printf "\n5.0.0\n"

printf "\n Concs are actually the same, but in different units \n\n"

tacunit -yconv=Bq/ml calc2_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f output.tac
$PROGRAM calc1_s.tac - calc2_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n5.0.1\n"

printf "\n Option --force has no effect here \n\n"

rm -f output.tac
$PROGRAM --force calc1_s.tac - calc2_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n5.1.0\n"

tacunit -yconv=kBq/ml calc2_s.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc1_s.tac calc1_su.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f calc2_s.tac calc2_su.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -yset=unknown calc1_su.tac calc2_su.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n Unknown conc units \n\n"

rm -f output.tac stdout.txt
$PROGRAM calc1_s.tac - calc2_su.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt Error "incompatible units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac stdout.txt
$PROGRAM calc1_su.tac - calc2_s.tac output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt Error "incompatible units."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n5.1.1\n"

printf "\n With option --force ok \n\n"

rm -f output.tac stdout.txt
$PROGRAM --force calc1_s.tac - calc2_su.tac output.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -xunit=y -yunit=y -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.tac stdout.txt
$PROGRAM --force calc1_su.tac - calc2_s.tac output.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -x=y -y=y -abs=0.01 -rel=0.5 calc2a_s.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "\n   Misc \n"
printf "\n===================================================================\n"


printf "\n6.0.0\n"

printf "\n Simple format, same sample times \n\n"

rm -f output.dft
$PROGRAM -f calc5a.dft : calc5b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -x=y -y=y -abs=0.01 -rel=0.5 calc5c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n6.0.1\n"

printf "\n Option --force not needed now since units in comments \n\n"

rm -f output.dft
$PROGRAM calc6a.dft : calc6b.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
tacmatch -x=y -y=y -abs=0.01 -rel=0.5 calc6c.dft output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n6.0.2\n"

printf "\n ... division should have changed conc units to unitless \n\n"
rm -f stdout.txt
tacunit output.dft &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt timeunit min
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "ok\n"
iftisval stdout.txt unit unitless
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
