#!/bin/bash
#: Title      : test_tacfcont
#: Date       : 2023-06-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacfcont$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n making test data \n"

if [ ! -f data1.tac ] || [ ! -f correct1.tac ]; then
  printf "start[seconds]	end[bq/cc]	R1	R2\n" > data1.tac
  printf "0.0	10.0	20.0	0.0\n" >> data1.tac
  printf "60.0	100.0	5.0	80.0\n" >> data1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "start[seconds]	end[bq/cc]	R1	R2\n" > correct1.tac
  printf "0.0	10.0	20.0	0.0\n" >> correct1.tac
  printf "10.0	60.0	14.0	32.0\n" >> correct1.tac
  printf "60.0	100.0	5.0	80.0\n" >> correct1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data2.tac ] || [ ! -f correct2.tac ]; then
  printf "start[seconds]	end[bq/cc]	R1	R2\n" > correct2.tac
  printf "0.0	2.0	1.0	0.0\n" >> correct2.tac
  printf "2.0	4.0	2.0	1.0\n" >> correct2.tac
  printf "4.0	6.0	3.0	2.0\n" >> correct2.tac
  printf "6.0	8.0	4.0	3.0\n" >> correct2.tac
  printf "8.0	10.0	5.0	4.0\n" >> correct2.tac
  printf "10.0	12.0	6.0	5.0\n" >> correct2.tac
  printf "12.0	14.0	7.0	6.0\n" >> correct2.tac
  printf "14.0	16.0	8.0	7.0\n" >> correct2.tac
  printf "16.0	18.0	9.0	8.0\n" >> correct2.tac
  printf "18.0	20.0	10.0	9.0\n" >> correct2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "start[seconds]	end[bq/cc]	R1	R2\n" > data2.tac
  printf "0.0	2.0	1.0	0.0\n" >> data2.tac
  printf "2.0	4.0	2.0	1.0\n" >> data2.tac
  printf "4.0	6.1	3.0	2.0\n" >> data2.tac
  printf "6.0	8.0	4.0	3.0\n" >> data2.tac
  printf "8.0	10.0	5.0	4.0\n" >> data2.tac
  printf "10.0	12.0	6.0	5.0\n" >> data2.tac
  printf "12.1	14.0	7.0	6.0\n" >> data2.tac
  printf "14.0	16.0	8.0	7.0\n" >> data2.tac
  printf "16.0	18.0	9.0	8.0\n" >> data2.tac
  printf "18.0	20.0	10.0	9.0\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


if [ ! -f data3.tac ]; then
  printf "start[seconds]	end[bq/cc]	R1	R2\n" > data3.tac
  printf "0.0	2.0	1.0	0.0\n" >> data3.tac
  printf "2.0	4.0	2.0	1.0\n" >> data3.tac
  printf "4.0	6.0	3.0	2.0\n" >> data3.tac
  printf "6.0	8.0	4.0	3.0\n" >> data3.tac
  printf "8.0	10.0	5.0	4.0\n" >> data3.tac
  printf "10.0	13.0	6.0	5.0\n" >> data3.tac
  printf "12.0	14.0	7.0	6.0\n" >> data3.tac
  printf "14.0	16.0	8.0	7.0\n" >> data3.tac
  printf "16.0	18.0	9.0	8.0\n" >> data3.tac
  printf "18.0	20.0	10.0	9.0\n" >> data3.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: File with large gap and two TACs. \n"
printf " Test case 2: Just check for gaps and overlap. \n"
printf " Expected result: Overlap/gaps reported, file not modified. \n\n"

cp -f data1.tac temp.tac

$PROGRAM temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "frame times are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 data1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: File with large gap and two TACs. \n"
printf " Test case 2: Fix the large gap. \n"
printf " Expected result: Result file contents are correct. \n\n"

$PROGRAM -fix temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Note" "fixing frame times that are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: File has no gaps or overlap. \n"
printf " Test case 2: Just check for gaps and overlap. \n"
printf " Expected result: No overlap/gaps reported, file not modified. \n\n"

$PROGRAM temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Note" "frame times are contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: File has no gaps or overlap. \n"
printf " Test case 2: Option to fix. \n"
printf " Expected result: No overlap/gaps reported, file not modified. \n\n"

$PROGRAM -fix temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Note" "frame times are contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct1.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: File with small gap and overlap. \n"
printf " Test case 2: Just check for gaps and overlap. \n"
printf " Expected result: Overlap/gaps reported, file not modified. \n\n"

cp -f data2.tac temp.tac

$PROGRAM temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "frame times are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 data2.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case 1: File with small gap and overlap. \n"
printf " Test case 2: Fix. \n"
printf " Expected result: Overlap/gap reported and fixed. \n\n"

$PROGRAM -fix temp.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Note" "fixing frame times that are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct2.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: File with large overlap that cannot be fixed. \n"
printf " Test case 2: Just check for gaps and overlap. \n"
printf " Expected result: Overlap/gaps reported, file not modified. \n\n"

cp -f data3.tac temp.tac

$PROGRAM temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "frame times are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 data3.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case 1: File with large overlap that cannot be fixed. \n"
printf " Test case 2: Trying to fix. \n"
printf " Expected result: Error reported, file not modified. \n\n"

$PROGRAM -fix temp.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Note" "fixing frame times that are not contiguous."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "large frame overlap."
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 data3.tac temp.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
