#!/bin/bash
#: Title      : test_tacmsamp
#: Date       : 2019-06-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../tacmsamp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

#printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f data1.dat ]; then
  printf "0 0 1\n" > data1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data2.dat ]; then
  printf "0 0 1\n" >  data2.dat
  printf "1 1.5 2.5\n" >> data2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3.dat ]; then
  printf "0 0 1\n" >  data3.dat
  printf "1 1 2\n" >> data3.dat
  printf "1 2 3\n" >> data3.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3na.dat ]; then
  printf "0 0 1\n" >  data3na.dat
  printf "1 1 2\n" >> data3na.dat
  printf ". 2 3\n" >> data3na.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data4nay.dat ]; then
  printf "0 0 1\n" >  data4nay.dat
  printf "1 1 2\n" >> data4nay.dat
  printf "1 . 3\n" >> data4nay.dat
  printf "1 2 .\n" >> data4nay.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

printf "\n making test data with frame times\n"

if [ ! -f data2.tac ]; then
  printf "start[seconds]	end[Bq/ml]	tac1	tac2\n" >  data2.tac
  printf "0	60	0	1.0\n" >> data2.tac
  printf "60	120	1.5	2.5\n" >> data2.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3.tac ]; then
  printf "start[seconds]	end[Bq/ml]	tac1	tac2\n" >  data3.tac
  printf "0	60	0	1.0\n" >> data3.tac
  printf "60	120	1.0	2.0\n" >> data3.tac
  printf "60	120	2.0	3.0\n" >> data3.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3na.tac ]; then
  printf "start[seconds]	end[Bq/ml]	tac1	tac2\n" >  data3na.tac
  printf "0	60	0	1.0\n" >> data3na.tac
  printf "60	.	1.0	2.0\n" >> data3na.tac
  printf "60	120	2.0	3.0\n" >> data3na.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data4nay.tac ]; then
  printf "start[seconds]	end[Bq/ml]	tac1	tac2\n" >  data4nay.tac
  printf "0	60	0	1.0\n" >> data4nay.tac
  printf "60	120	1.0	2.0\n" >> data4nay.tac
  printf "60	120	2.0	\n" >> data4nay.tac
  printf "60	120		3.0\n" >> data4nay.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case 1: Check if multiple samples. \n"
printf " Test case 2: File has only one sample. \n"
printf " Expected result: No multiples found. \n\n"

cp -f data1.dat test.dat

$PROGRAM test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.1 \n"
printf " Test case 1: Check if multiple samples. \n"
printf " Test case 2: File has two different samples. \n"
printf " Expected result: No multiples found. \n\n"

cp -f data2.dat test.dat

$PROGRAM test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.2 \n"
printf " Test case 1: Check if multiple samples. \n"
printf " Test case 2: File has three samples, two of them same. \n"
printf " Expected result: Multiples found. \n\n"

cp -f data3.dat test.dat

$PROGRAM test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.0.3 \n"
printf " Test case 1: Check if multiple samples. \n"
printf " Test case 2: File has three samples, one with missing sample time. \n"
printf " Expected result: No multiples found. \n\n"

cp -f data3na.dat test.dat

$PROGRAM test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 1.1.0 \n"
printf " Test case 1: Check if multiple frames. \n"
printf " Test case 2: File has two different frames. \n"
printf " Expected result: No multiples found. \n\n"

cp -f data2.tac test.tac

$PROGRAM test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.1.1 \n"
printf " Test case 1: Check if multiple frames. \n"
printf " Test case 2: File has three frames, two of them same. \n"
printf " Expected result: Multiples found. \n\n"

cp -f data3.tac test.tac

$PROGRAM test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 1.1.2 \n"
printf " Test case 1: Check if multiple frames. \n"
printf " Test case 2: File has three frames, two of them same but with missing time. \n"
printf " Expected result: No multiples found. \n\n"

cp -f data3na.tac test.tac

$PROGRAM test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"

printf "\n\n 2.0.0 \n"
printf " Test case 1: Try to fix multiple samples. \n"
printf " Test case 2: File has only one sample. \n"
printf " Expected result 1: No multiples found. \n"
printf " Expected result 2: File not modified. \n\n"

cp -f data1.dat test.dat

$PROGRAM -mean test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data1.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 2.0.1 \n"
printf " Test case 1: Try to fix multiple samples. \n"
printf " Test case 2: File has two different samples. \n"
printf " Expected result 1: No multiples found. \n"
printf " Expected result 2: File not modified. \n\n"

cp -f data2.dat test.dat

$PROGRAM -mean test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data2.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 2.0.2 \n"
printf " Test case 1: Try to fix multiple samples. \n"
printf " Test case 2: File has three samples, one with missing sample time. \n"
printf " Expected result 1: No multiples found. \n"
printf " Expected result 2: File not modified. \n\n"

cp -f data3na.dat test.dat

$PROGRAM -mean test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data3na.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 2.0.3 \n"
printf " Test case 1: Try to fix multiple samples. \n"
printf " Test case 2: File has three samples, two of them same. \n"
printf " Expected result: Multiples replaced with means. \n\n"

cp -f data3.dat test.dat

$PROGRAM -mean test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data3.dat test.dat
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacmatch data2.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 2.0.4 \n"
printf " Test case 1: Try to fix multiple samples. \n"
printf " Test case 2: File has four samples, three of them same, but with missing y. \n"
printf " Expected result: Multiples replaced with means. \n\n"

cp -f data4nay.dat test.dat

$PROGRAM -mean test.dat > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.dat" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data4nay.dat test.dat
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacmatch data2.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n\n 2.1.0 \n"
printf " Test case 1: Try to fix multiple frames. \n"
printf " Test case 2: File has two different frames. \n"
printf " Expected result 1: No multiples found. \n"
printf " Expected result 2: File not modified. \n\n"

cp -f data2.tac test.tac

$PROGRAM -mean test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data2.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 2.1.1 \n"
printf " Test case 1: Try to fix multiple frames. \n"
printf " Test case 2: File has three frames, two of them same. \n"
printf " Expected result: Multiples replaced with means. \n\n"

cp -f data3.tac test.tac

$PROGRAM -mean test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data3.tac test.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacmatch data2.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 2.1.2 \n"
printf " Test case 1: Try to fix multiple frames. \n"
printf " Test case 2: File has three frames, two of them same but with missing time. \n"
printf " Expected result 1: No multiples found. \n"
printf " Expected result 2: File not modified. \n\n"

cp -f data3na.tac test.tac

$PROGRAM -mean test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "no multiple samples"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data3na.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 2.1.3 \n"
printf " Test case 1: Try to fix multiple frames. \n"
printf " Test case 2: File has four frames, three of them same, but with missing y. \n"
printf " Expected result: Multiples replaced with means. \n\n"

cp -f data4nay.tac test.tac

$PROGRAM -mean test.tac > stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "test.tac" "multiple samples found"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data4nay.tac test.tac
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tacmatch data2.tac test.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
