Coding practice for tpcclib
===========================

## Requirements ##

We will assume that compiler supports C99 and most POSIX functions.
Thus Visual Studio is not supported (I guess).

[CMake](http://www.cmake.org) is used to build the Makefiles, to [run tests](testing.md), and to 
[build packages](packaging.md).

## Library functions ##

Try to keep program `main()` functions as small as possible, doing just command-line argument 
processing. Write everything else in functions, preferably into libraries, for easy reuse.

When adding a new function() to a library, add also test_function(). If in a extreme hurry, 
leave the test function empty, just returning 0.

All functions should be thread safe. For this reason, do not use strtok().

All functions, typedefs, and global variables in libraries should start with string referring to 
the data (struct) that it mainly works with so that it can be easily found in alphabetical lists 
created by [Doxygen](http://www.doxygen.org).

Use the same name for struct tag and typedef.

When possible, replace
- sprintf() with snprintf(),
- strcat() with strlcat(),
- strcpy() with strlcpy(), and
- strlen() with strnlen().

## fprintf() and exponent

In Unix and Linux the exponent always contains at least two digits, but in Windows, the exponent 
contains three digits by default, e.g. `1.5e002`. This can be altered by Microsoft-specific 
_set_output_format function, which can also be called when using MinGW compilers.

For example, add the following lines to the application C code before using (f)printf:

    #ifdef MINGW
      // Use Unix/Linux default of two-digit exponents in MinGW on Windows
      _set_output_format(_TWO_DIGIT_EXPONENT);
    #endif

## ftell()

Remember that ftell() returns `long int`, with negative value in case of an error.
After checking for this, you may need to cast the output into `unsigned long int`.
With large binary files, especially DICOM, and when compiling for Windows, using strictly
the latter may prevent spurious errors.


## Documentation ##

Write the code so that it is easy to read, avoiding obfuscated optimization for speed. 
Modern compilers will optimize the code anyway.

Use [Doxygen](http://www.doxygen.org) style comments. Start all `.c` and `.h` files with Doxygen 
comment including at least accurate file name and brief description (see existing files).
Do not use same name for files in different folders, because if you do, then Doxygen will not 
include either of those. 

Use extension .md for additional files, because Doxygen will automatically include these in 
documentation. Let CMake copy these to .txt files when necessary.

Add own menu items to Doxygen documentation by editing file `DoxygenLayout.xml`.

## Versioning ##

All programs and libraries will have the same version number, set in `CMakeLists.txt` in the root 
folder. This should make it sure that all binaries (executables) in a package version are compatible 
with each other, in case for example file format is slightly changed. 
And it will be easier to reinstall old version for processing old data sets.

## Command-line parameters ##

Use dedicated function to process standard command-line options `--help`, `-h`, etc.

Other commonly used options are:
`-k` or `--keep` 
  Suppress the normal deletion of some file, message, or resource.
`--dry`
  Do not actually do anything, just show to user what would be done without
  the option. 

![xkcd comic](https://imgs.xkcd.com/comics/code_quality.png "Read a coding style guide")
