Installing tpcclib
==================

Programs that are currently included in TPCCLIB are listed in 
[http://www.turkupetcentre.net/petanalysis/tpcclib/doc/](http://www.turkupetcentre.net/petanalysis/tpcclib/doc/index.html).

# Installing the programs (application binaries) for use

Download the binary installation package for your platform, using the links on the download page. 
Open the ZIP or GZ package, open bin folder in it, and extract the applications that you need 
(or all of them) to a folder in your computer. You may need to tell your operating system to 
search the target path for applications.

See more detailed instructions for 
[Windows](http://www.turkupetcentre.net/petanalysis/sw_install.html#windows),
[Linux](http://www.turkupetcentre.net/petanalysis/sw_install.html#linux), and
[macOS](http://www.turkupetcentre.net/petanalysis/sw_install.html#mac).


# Installing from the source code package

[CMake](https://www.cmake.org) is used to control TPCCLIB compilation, testing, and packaging.
The process is tested in Windows 11 and Ubuntu Linux.

## Install command line tools for compilation

Installing of the C compiler is out of the scope of this documentation. You will need
root (administrator) access to the computer.
Some instructions on setting up the development environment are given for
[Linux](http://www.turkupetcentre.net/petanalysis/swdev_linux.html), and
[Windows](http://www.turkupetcentre.net/petanalysis/swdev_windows.html).


## Download TPCCLIB source code

Clone the source codes from Git repository, or download the source code package and extract 
the files on your computer.

### Clone from Git repository

Create folder `tpcclib` for source codes and building, and clone the sources of a specific 
TPCCLIB release into a new folder `src`:

~~~~~~~~~~~~~~~~~~
cd
mkdir tpcclib
cd tpcclib
git clone --depth 1 --branch v0.7.9 https://gitlab.utu.fi/vesoik/tpcclib.git src
~~~~~~~~~~~~~~~~~~

Change the version number in the `--branch` option to the latest release. If you want to build 
the most recent source code versions (not recommended for production use), then leave out 
the option `--branch v0.7.7`. If you are a programmer and plan to edit the source codes and 
commit the changes, you should leave out both options, and use your UTU user name:

    git clone https://username@gitlab.utu.fi/vesoik/tpcclib.git src

## Compilation

The Git commit above wrote the source codes into folder ~/tpcclib/src/. 
Create the build path(s), **not under the source path**, and not under network folders, or 
shared folders in virtual machine, because that would lead to "Clock skew detected" warnings
and incomplete or failed compilation.

If you are building executables for the current operating system only, then the recommended 
directory structure is this:

    tpcclib
    ├───src
    └───build

If you will build executables for Linux and Windows systems, then
create separate build folder for each system:

    tpcclib
    ├───src
    ├───linux
    └───win

Move into the build directory, and then run `cmake` command, specifying the source path 
(in this example `cmake ../src`), and optionally (-G) the make system generator. 
Alternatively, in the root tpcclib folder, enter the names of both source and build paths 
(in this example `cmake -S ./src -B ./linux`).
You can enter `cmake --help` to see available options. See below for [examples](#examples).

Then run `make` (in Linux, and Git for Windows, bash shell with GCC):

    make install

Running command `make install` creates the program executables (binaries) in your build directory
under folder `bin` but does not copy them to a directory where they would be seen by your
operating system. You can either change the CMake settings to specify another installation folder
(see [below](#setting-installation-path)), or use the binaries from that folder, 
if you add the folder into PATH.
For example in macOS you could again edit the file `${HOME}/.bash_profile`:

    cd
    nano .bash_profile

to contain line:

    export PATH="$HOME/tpcclib/build/bin:/Applications/CMake.app/Contents/bin:$PATH"

You can also create the source and binary [packages](packaging.md) for distribution to other
computers.

\anchor setting-installation-path
### Setting installation path

Installation directory is set to the current working directory in `CMakeLists.txt`. 
You can change the path by changing the line

    set(CMAKE_INSTALL_PREFIX ".")

, or you can remove the line: then cmake installs binaries to the default directory, which is 
/usr/local on UNIX/Linux and c:/Program Files on Windows.
You can also set the installation directory from command-line when executing
cmake, for example:

    cmake -D CMAKE_INSTALL_PREFIX=/c/bin ../tpcclib

Notice that if you toggle compiler define options with -D, like above, the Makefile system does 
not recognize such a change. If you change definitions, then `make clean`.


## Testing

After successful `make install`, you can test the library and applications.
[Please read the separate page on testing](testing.md).
Compiling and testing takes about 10 min on a modern laptop with SSD and quad-core CPU.


## Creating TPCCLIB documents

Create [Doxygen](http://doxygen.org) documentation for the library, if necessary, by first moving 
to the source code directory, and then executing `doxygen` in each of the main source folders: 
    
~~~~~~~~~~~~~~~~~~
cd ~/tpcclib/src
doxygen
cd v1
doxygen
cd v2
doxygen
~~~~~~~~~~~~~~~~~~

If usage information for the individual programs are required, then copy the script `makedoc.sh` 
from the source path into build directory, and run it:

~~~~~~~~~~~~~~~~~~
cd ~/tpcclib/build
./makedoc.sh
~~~~~~~~~~~~~~~~~~

After this the directory structure will be something like this, depending on the operating systems
for which you have built the programs:

    tpcclib
    ├───packages
    ├───src
    ├───tpcclib-doc
    ├───linux
    │   ├───bin
    │   └───doc
    └───win
        ├───bin
        └───doc

Distributable source and binary packages will be located in `packages` folder,
library documentation in `tpcclib-doc` folder, usage information for binaries in `win/doc`, and 
compiled binaries in the `bin` folder(s).

\anchor examples
## Examples

### GNU Linux and Bash on Ubuntu on Windows

~~~~~~~~~~~~~~~~~~
cd ~/tpcclib/build
cmake ../src
make -j 2 install
ctest --output-on-failure --parallel 2
make -j 2 package package_source
~~~~~~~~~~~~~~~~~~

Options `-j 2` and `--parallel 2` in the example above speed up the process by using two processor 
cores or threads simultaneously.


### Windows with Git bash on Windows

Using GCC from [Equation Solution](http://www.equation.com/):

~~~~~~~~~~~~~~~~~~
cd ~/tpcclib/build
cmake -G "MSYS Makefiles" ../src
make -j 2 install
ctest --output-on-failure --parallel 2
make -j 2 package
~~~~~~~~~~~~~~~~~~

Notice that make is used without option -j 2 in this example;
parallel compiling may or may not work in Windows.

If CMake stops with error `sh.exe was found in your PATH`, you can comment out this check from file 
`CMakeMinGWFindMake.cmake`, which is located in the CMake directory, for instance in path 
`C:\Program Files\CMake\share\cmake-3.25\Modules\`. The error message gives the detailed path of the
file to edit. Alternatively, you can rename the `sh.exe` in `C:\Program Files\Git\usr\bin\`
(or similar) to for instance `sh-git.exe`.

If you get problems with F-Secure or other virus scanners in Windows with gcc, 
it may help to include link option -s to remove all symbol table and relocation 
information from (temporary) executables. For example:

~~~~~~~~~~~~~~~~~~
cmake -G "MSYS Makefiles" -D CMAKE_C_FLAGS:STRING="-s" ../src
~~~~~~~~~~~~~~~~~~


## More about CMake

The `Makefile` created by CMake is robust if you make source file changes, and it can manage 
complex module dependencies. Only if the project is altered you will have to re-run Cmake so that 
the new addition gets included. There are however cases where you should rebuild all the source. 
For example, if you toggle compiler define options (`-D`), then `make clean` before compilation.

If you run into problems you should consider removing the contents of the build directory and 
starting over.

