#!/bin/bash
#: Title      : test_fit_rrtm
#: Date       : 2022-03-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_rrtm$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f rpplasma.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f frames.dat ] || [ ! -f correct_rrtm1.res ] || [ ! -f correct_rrtm2.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making data for testing \n"

if [ ! -f sim1.par ]; then
  rm -f rrtm1_full.tac rrtm2_full.tac rrtm_full.tac
  printf "# model := SER3TCM\n" > sim1.par
  printf "Parameters,K1,k2,k3,k4,k5,k6,Vb,f,fA\n" >> sim1.par
  printf "cereb,0.06,0.12,0.0,0.0,0,0,0,0,0\n"    >> sim1.par
  printf "put_1,0.02,0.04,0.005,0,0,0,0,0,0\n"    >> sim1.par
  printf "put_2,0.03,0.06,0.010,0,0,0,0,0,0\n"    >> sim1.par
fi

if [ ! -f rrtm_full1.tac ]; then
  rm -f rrtm.tac rrtm_full.tac
  sim_3tcm -nosub sim1.par rpplasma.dat rpplasma.dat rrtm1_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f sim2.par ]; then
  rm -f rrtm_full.tac rrtm2_full.tac
  printf "# model := RRTM\n" > sim2.par
  printf "Parameters,R1[unitless],k2[1/min],k3[1/min]\n" >> sim2.par
  printf "putams,0.333333,0.04,0.005\n"                  >> sim2.par
fi

if [ ! -f rrtm2_full.tac ]; then
  rm -f rrtm_full.tac rrtm.tac
  tacadd -ovr refinput.tac rrtm1_full.tac cereb
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  sim_rtcm -nosub sim2.par refinput.tac rrtm2_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f rrtm_full.tac ]; then
  rm -f rrtm.tac cereb.tac rrtmnor.tac
  tacadd -ovr rrtm_full.tac rrtm2_full.tac rrtm1_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy --force rrtm_full.tac sim1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f rrtm.tac ] || [ ! -f rrtmnor.tac ] || [ ! -f cereb.tac ]; then
  simframe rrtm_full.tac frames.dat rrtm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacweigh -wf rrtm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr rrtmnor.tac rrtm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr -move cereb.tac rrtmnor.tac cereb
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y rrtm.svg rrtm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Fit TACs simulated with realistic range of parameters. \n"
printf " Test case 2: Reference inside TTAC file. \n"
printf " Expected result 1: Result file is created, and results are close to correct \n"
printf " Expected result 2: SVG plot is created. \n"
printf " Expected result 3: Fitted TACs should be close to original TACs.\n\n"

rm -f fit_1_0_0.res fit_1_0_0.tac fit_1_0_0.svg

$PROGRAM -fit=fit_1_0_0.tac -svg=fit_1_0_0.svg rrtm.tac cereb 120 fit_1_0_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

if [ ! -f fit_1_0_0.tac ] || [ ! -f fit_1_0_0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.5 -rel=0.5 rrtm.tac fit_1_0_0.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


resmatch -abs=0.01 -header=y -param=y -regions=y -res=1-3 correct_rrtm1.res fit_1_0_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Fit TACs simulated with realistic range of parameters. \n"
printf " Test case 2: Reference in separate TAC file. \n"
printf " Expected result 1: Result file is created, and results are close to correct \n"
printf " Expected result 2: SVG plot is created. \n"
printf " Expected result 3: Fitted TACs should be close to original TACs.\n\n"

rm -f fit_1_1_0.res fit_1_1_0.tac fit_1_1_0.svg

$PROGRAM -fit=fit_1_1_0.tac -svg=fit_1_1_0.svg rrtmnor.tac cereb.tac 120 fit_1_1_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

if [ ! -f fit_1_1_0.tac ] || [ ! -f fit_1_1_0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.5 -rel=0.5 rrtmnor.tac fit_1_1_0.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


resmatch -abs=0.01 -header=y -param=y -regions=y -res=1-3 correct_rrtm2.res fit_1_1_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.1 \n"
printf " Test case 1: Fit TACs simulated with realistic range of parameters. \n"
printf " Test case 2: Reference in separate simple file without headers. \n"
printf " Expected result 1: Result file is created, and results are close to correct \n"
printf " Expected result 2: Fitted TACs should be close to original TACs.\n\n"

rm -f fit_1_1_1.res fit_1_1_1.tac
tacformat -f=SIMPLE -hdr=no -mid cereb.tac cereb.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -fit=fit_1_1_1.tac rrtmnor.tac cereb.dat 120 fit_1_1_1.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.5 -rel=0.5 rrtmnor.tac fit_1_1_1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


resmatch -abs=0.01 -header=n -param=y -regions=y -res=1-3 correct_rrtm2.res fit_1_1_1.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

