#!/bin/bash
#: Title      : test_dft2img
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../dft2img$EXT;
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f plasma.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f frames.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f origf.dft ]; then rm --force orig.dft ; fi
if [ ! -f orig.dft ]; then
  printf "\n\nCreating orig.dft\n"
  rm -f origf.dft
  
  p2t_3c -nosub plasma.dat 0.050 0.025 0 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.100 0 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.250 0 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub plasma.dat 0.200 0.050 0.005 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.200 0.200 0.005 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.200 0.800 0.005 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub plasma.dat 0.050 0.025 0.05 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.100 0.05 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.250 0.05 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub plasma.dat 0.500 0.050 0.5 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.500 0.400 0.5 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.500 0.800 0.5 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f origf.dft ]; then
  printf "\n\nCreating origf.dft\n"
  simframe orig.dft frames.dat origf.dft F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0 Unknown option\n\n"

$PROGRAM -stupidoption origf.dft dynamic.img 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n0.2.0 Extra argument\n\n"

$PROGRAM origf.dft dynamic.img dynamic.roi extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.0.0 Make a GE Advance image\n\n"

rm -f dynamic.img dynamic.dft dynamic.roi
$PROGRAM -SCANNER=adv -dim=128 -zoom=1.5 origf.dft dynamic.img dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft dynamic.img dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tacs1.svg -s origf.dft -l dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.5 -x=y -y=y -tacnames=n -xunit=y -yunit=y origf.dft dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.1.0  Make an HRplus image\n\n"

rm -f dynamic.v dynamic.dft dynamic.roi
$PROGRAM -SCANNER=HR+ -dim=64 -zoom=1.5 origf.dft dynamic.v dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft dynamic.v dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tacs2.svg -s origf.dft -l dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.5 -x=y -y=y -tacnames=n -xunit=y -yunit=y origf.dft dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.2.0  Make an HRRT image\n\n"

rm -f dynamic.v dynamic.dft dynamic.roi
$PROGRAM -SCANNER=HRRT -dim=128 origf.dft dynamic.v dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft dynamic.v dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg tacs2.svg -s origf.dft -l dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.5 -x=y -y=y -tacnames=n -xunit=y -yunit=y origf.dft dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n2.0.0  Create template image\n\n"

rm -f template.dat template.v template.roi
echo 0 1 2 3 4 5 6 7 8 9 10 11 12 > template.dat
$PROGRAM -SCANNER=HR+ -dim=64 template.dat template.v template.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n2.0.1  Continue by making image using that template image\n\n"

rm -f dynamic.v
$PROGRAM -tpl=template.v -SCANNER=HR+ -dim=64 origf.dft dynamic.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft dynamic.v template.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.5 -x=y -y=y -tacnames=n -xunit=y -yunit=y origf.dft dynamic.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

