#!/bin/bash
#: Title      : test_e7emhdr
#: Date       : 2014-09-04
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e7emhdr$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n Creating test image \n"
rm -f test1.dat test2.dat ecat7.v
echo 1 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 > test1.dat
echo 1 6 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 3 3 6 3 6 3 6 3 6 6 3 6 3 6 3 6 > test2.dat
dft2img -scanner=HR+ -dim=64 -nodecay test1.dat plane1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -scanner=HR+ -dim=64 -nodecay test2.dat plane2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgadd frame1.v plane1.v plane2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc frame1.v x 1.5 frame2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
ecatcat frame1.v frame2.v ecat7.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f header.ift
printf "\n Creating header file \n"
echo patient_name := Einstein Albert   > header.ift
echo radiopharmaceutical := O-15 WATER >>header.ift
echo study_description := brain scan   >>header.ift
echo facility_name := Turku PET Centre >>header.ift

printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n1.0.0 Edit image with header file \n\n"

rm -f edited.v newheader.ift
cp -f ecat7.v edited.v
$PROGRAM edited.v header.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.v > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift patient_name "Einstein Albert"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift radiopharmaceutical "O-15 WATER"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift study_description "brain scan"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval newheader.ift facility_name "Turku PET Centre"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "=====================================================================\n"

printf "\n2.0.0 Edit image with command-line arguments \n\n"

rm -f edited.v newheader.ift
cp -f ecat7.v edited.v
$PROGRAM edited.v radiopharmaceutical := O-15 WATER
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.v > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift radiopharmaceutical "O-15 WATER"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.0 Try to set scan start time \n\n"

rm -f edited.v newheader.ift
cp -f ecat7.v edited.v
$PROGRAM edited.v scan_start_time := 2014-09-04 11:15:13
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.v > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift scan_start_time "2014-09-04 11:15:13"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.1.1 Try to unset scan start time \n\n"

rm -f edited.v newheader.ift
cp -f ecat7.v edited.v
$PROGRAM edited.v scan_start_time := 1970-01-01 00:00:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr edited.v > newheader.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
#cat newheader.ift
iftisval newheader.ift scan_start_time "1970-01-01 00:00:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

