#!/bin/bash
#: Title      : test_ecattime
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecattime$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f origdata.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

if [ ! -f pet.v ] || [ ! -f pet.img ]; then
  printf "\n making pet.v and pet.img\n"
  dft2img -scanner=HRRT -dim=32 -zoom=2 origdata.dft pet.v pet.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt pet.v 2003-12-13 12:00:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc pet.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft pet.v pet.roi pet0.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 pet.v pet.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"

fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf "Correct a delayed scan to injection start time \n"
printf "with time difference \n\n"

# Make data for comparing results
rm -f correct.dft
tactime -decay -i=C-11 origdata.dft 1224 correct.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min correct.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


printf "\n ECAT 6 \n\n"

cp -f pet.img temp.img
# Assume that scan was started one halflife after injection
$PROGRAM temp.img 20.4 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "corrected ECAT 6 frames\n"
eframe temp.img
img2dft temp.img pet.roi pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n ECAT 7 \n\n"

cp -f pet.v temp.v
# Assume that scan was started one halflife after injection
$PROGRAM temp.v 20.4 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "corrected ECAT 7 frames\n"
eframe temp.v
img2dft temp.v pet.roi pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n 1.0.1 \n"
printf "Correct a delayed scan to injection start time\n"
printf "with time difference AGAIN - this should lead to an error \n\n"

printf "\n ECAT 6 \n\n"

$PROGRAM temp.img 20.4 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "times seem to be already corrected."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n ECAT 7 \n\n"

$PROGRAM temp.v 20.4 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "times seem to be already corrected."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n 1.0.2 \n"
printf "Correct the delayed scan from injection start time BACK to scan start\n"
printf "with time difference \n\n"

# Make data for comparing results
cp -f origdata.dft correct.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min correct.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n ECAT 6 \n\n"

$PROGRAM temp.img -20.4 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "back-corrected ECAT 6 frames\n"
eframe temp.img
img2dft temp.img pet.roi pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n ECAT 7 \n\n"

$PROGRAM temp.v -20.4 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "back-corrected ECAT 7 frames\n"
eframe temp.v
img2dft temp.v pet.roi pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n===================================================================\n"


printf "\n 2.0.0 \n"
printf "Correct a delayed scan to injection start time \n"
printf "with injection time \n\n"

# Make data for comparing results
rm -f correct.dft
tactime -decay -i=C-11 origdata.dft 1224 correct.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min correct.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi


printf "\n ECAT 6 \n\n"

cp -f pet.img temp.img
# Assume that scan was started one halflife after injection
$PROGRAM temp.img 11:39:36 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "corrected ECAT 6 frames\n"
eframe temp.img
img2dft temp.img pet.roi pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"


printf "\n ECAT 7 \n\n"

cp -f pet.v temp.v
# Assume that scan was started one halflife after injection
$PROGRAM temp.v 11:39:36 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "corrected ECAT 7 frames\n"
eframe temp.v
img2dft temp.v pet.roi pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n 2.0.1 \n"
printf "Correct a delayed scan to injection start time\n"
printf "with injection time AGAIN - this should lead to an error \n\n"

printf "\n ECAT 6 \n\n"

$PROGRAM temp.img 11:39:36 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "times seem to be already corrected."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n ECAT 7 \n\n"

$PROGRAM temp.v 11:39:36 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "times seem to be already corrected."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n-------------------------------------------------------------------\n"

printf "\n 2.0.2 \n"
printf "Correct the delayed scan from injection start time BACK to scan start\n"
printf "with injection time \n\n"

# Make data for comparing results
cp -f origdata.dft correct.dft 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min correct.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

printf "\n ECAT 6 \n\n"

$PROGRAM temp.img 12:00:00 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "back-corrected ECAT 6 frames\n"
eframe temp.img
img2dft temp.img pet.roi pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"

printf "\n ECAT 7 \n\n"

$PROGRAM temp.v 12:00:00 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "back-corrected ECAT 7 frames\n"
eframe temp.v
img2dft temp.v pet.roi pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=1 correct.dft pet2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n Passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

