#!/bin/bash
#: Title      : test_egetstrt
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../egetstrt$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

rm -f temp.dat test?.img test?.v
echo 1 1 2 3 4 >  temp.dat
echo 3 2 3 4 5 >> temp.dat
dft2img -Scanner=HR+ -Dim=8 temp.dat test1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -Scanner=HR+ -Dim=4 temp.dat test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -Scanner=HR+ -Dim=6 temp.dat test3.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -Scanner=Adv -Dim=4 temp.dat test1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -Scanner=Adv -Dim=8 temp.dat test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dft2img -Scanner=Adv -Dim=6 temp.dat test3.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test1.v 2006-01-03 16:39:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test2.v 2006-01-03 16:40:30
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test3.v 2006-01-04 16:39:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f test2.v test4.v
esetstrt test1.img 2006-01-04 08:01:54
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test2.img 2006-01-04 09:02:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test3.img 2006-01-05 08:01:54
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
cp -f test2.img test4.img


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n0.1.0 File has no start time\n\n"

$PROGRAM -stupidoption test1.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.0.0 File has no start time\n\n"

printf "\n ECAT 7 \n\n"

cp -f test1.v temp.v
e7emhdr temp.v scan_start_time := 1900-01-01 00:00:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "temp.v does not contain scan start time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT 6 \n\n"

rm -f temp.img
e7to63 temp.v temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM temp.img 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "temp.img does not contain scan start time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n1.1.0 One file with valid time \n\n"

printf "\n ECAT 7 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT 6 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 08:01:54"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n1.2.0 Two files with valid time \n\n"

printf "\n ECAT 7 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.v test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:40:30"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT 6 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 08:01:54"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 09:02:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n1.3.0 Three files with valid time \n\n"

printf "\n ECAT 7 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.v test2.v test3.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:40:30"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT 6 \n\n"

rm -f times.ift
$PROGRAM -o=times.ift test1.img test2.img test3.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 08:01:54"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 09:02:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-05 08:01:54"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n2.0.0 Option -dif \n\n"

rm -f times.ift
$PROGRAM -dif -o=times.ift test1.v test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "1.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.1 Option -dif=min \n\n"

rm -f times.ift
$PROGRAM -dif=min -o=times.ift test1.v test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "1.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.2 Option -dif=sec \n\n"

rm -f times.ift
$PROGRAM -dif=sec -o=times.ift test1.v test2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "90"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.3 time difference is negative \n\n"

rm -f times.ift
$PROGRAM -dif=sec -o=times.ift test2.v test1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "-90"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n2.0.4 time difference is zero \n\n"

rm -f times.ift
$PROGRAM -dif=sec -o=times.ift test2.v test4.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n2.1.0 Difference between three files \n\n"

printf "\n ECAT 7 \n\n"

rm -f times.ift
$PROGRAM -dif=sec -o=times.ift test1.v test2.v test3.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-03 16:39:00"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "90"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "86400"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT 6 \n\n"

rm -f times.ift
$PROGRAM -dif=sec -o=times.ift test1.img test2.img test3.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time" "2006-01-04 08:01:54"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "3606"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval times.ift "scan_start_time_difference" "86400"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

