#!/bin/bash
#: Title      : test_imgbfbp
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imgbfbp$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f plasma.dat ] || [ ! -f frames.dat ] || [ ! -f shortframes.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f perfect.par ] || [ ! -f correct_bp.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_r1.tac ] || [ ! -f correct_k2.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f perfect.v ] || [ ! -f dynamic.v ]; then
  rm -f dynamic.img ana\dynamic.* nii\dynamic.*
  rm -f perfect.sif dynamic.sif
  printf "\n Simulate dynamic image applying SRTM\n"
  p2t_3c --silent -nosub plasma.dat  0.100 0.120 0 0 0 0 ref.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren ref.tac 1 ref
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe ref.tac shortframes.dat refperfect.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe ref.tac frames.dat refdynamic.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  sim_rtcm perfect.par ref.tac perf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe perf.tac shortframes.dat perfect.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=yes perfect.svg perfect.tac -l refperfect.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=hrrt -dim=9 -zoom=2.0 perfect.tac perfect.v test.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc perfect.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simframe perf.tac frames.dat dynamic.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=hrrt -dim=9 -zoom=2.0 dynamic.tac dynamic.v test.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f dynamic.img ]; then
  e7to63 -c=o dynamic.v dynamic.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f ana\dynamic.img ] || [ ! -f ana\dynamic.hdr ] || [ ! -f ana\dynamic.sif ]; then
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nii\dynamic.nii ] || [ ! -f nii\dynamic.sif ]; then
  ecat2nii -sif -o=nii dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f perfect.sif ] || [ ! -f dynamic.sif ]; then
  imgweigh perfect.v perfect.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgweigh dynamic.v dynamic.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless ECAT7 image data simulated with SRTM. \n"
printf " Test case 2: No SIF, ie weights from the image. \n"
printf " Test case 3: Computed SIF is saved. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft output.sif

$PROGRAM -min=0.009 -max=0.4 -thr=0 -savesif=output.sif perfect.v refperfect.tac output_bp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.sif ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Option -w1 to set weights to 1. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft

$PROGRAM -d2 -w1 -min=0.009 -max=0.4 -thr=0 perfect.v refperfect.tac output_bp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.sif ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Option -wf to set weights based on frame lengths. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft

$PROGRAM -d2 -wf -min=0.009 -max=0.4 -thr=0 perfect.v refperfect.tac output_bp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.sif ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Noiseless ECAT6 image data simulated with SRTM. \n"
printf " Test case 2: Weights from SIF. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.img output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 dynamic.img refdynamic.tac output_bp.img dynamic.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.img test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-------------------------------------------------------------------\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Analyze image. \n"
printf " Test case 2: Default SIF available but no prompts. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f ana/output.sif ana/output.hdr ana/output.img output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 ana/dynamic refdynamic.tac ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Analyze image. \n"
printf " Test case 2: Separate SIF with prompts and default SIF without prompts. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f ana/output.sif ana/output.hdr ana/output.img output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 ana/dynamic refdynamic.tac ana/output dynamic.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.2 \n"
printf " Test case 1: Analyze image. \n"
printf " Test case 2: Separate SIF with prompts and no default SIF at all. \n"
printf " Expected result: Correct results calculated. \n\n"

mv ana/dynamic.sif ana/dynamic.siiif
rm -f ana/output.sif ana/output.hdr ana/output.img output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 ana/dynamic refdynamic.tac ana/output dynamic.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
mv ana/dynamic.siiif ana/dynamic.sif
img2dft ana/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.3 \n"
printf " Test case 1: Analyze image. \n"
printf " Test case 2: No SIF available. \n"
printf " Expected result: Error. \n\n"

mv ana/dynamic.sif ana/dynamic.siiif
rm -f stdout.txt
rm -f ana/output.sif ana/output.hdr ana/output.img output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 ana/dynamic refdynamic.tac ana/output 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
mv ana/dynamic.siiif ana/dynamic.sif
iftisval stdout.txt "Error" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n 1.3.0 \n"
printf " Test case 1: NIfTI image. \n"
printf " Test case 2: Default SIF available but no prompts. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f nii/output.sif nii/output.nii output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 nii/dynamic refdynamic.tac nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.3.1 \n"
printf " Test case 1: NIfTI image. \n"
printf " Test case 2: Separate SIF with prompts and default SIF without prompts. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f nii/output.sif nii/output.nii output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 nii/dynamic refdynamic.tac nii/output dynamic.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.2 \n"
printf " Test case 1: NIfTI image. \n"
printf " Test case 2: Separate SIF with prompts and no default SIF at all. \n"
printf " Expected result: Correct results calculated. \n\n"

mv nii/dynamic.sif nii/dynamic.siiif
rm -f nii/output.sif nii/output.nii output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 nii/dynamic refdynamic.tac nii/output dynamic.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
mv nii/dynamic.siiif nii/dynamic.sif
img2dft nii/output test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.3 \n"
printf " Test case 1: NIfTI image. \n"
printf " Test case 2: No SIF available. \n"
printf " Expected result: Error. \n\n"

mv nii/dynamic.sif nii/dynamic.siiif
rm -f stdout.txt
rm -f nii/output.sif nii/output.nii output_bp.dft

$PROGRAM -min=0.009 -max=0.4 -thr=0 nii/dynamic refdynamic.tac nii/output 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
mv nii/dynamic.siiif nii/dynamic.sif
iftisval stdout.txt "Error" "image frame times not available."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Option -end with large time. \n"
printf " Test case 2: Weighting from separate SIF. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft

$PROGRAM -end=999 -d3 -min=0.009 -max=0.4 -thr=0 dynamic.v refdynamic.tac output_bp.v dynamic.sif > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt fittimeFinal "120 min"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case 1: Option -end with a bit shorter time than in the data. \n"
printf " Test case 2: Weighting from separate SIF. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft

$PROGRAM -end=100 -d3 -min=0.009 -max=0.4 -thr=0 dynamic.v refdynamic.tac output_bp.v dynamic.sif > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt fittimeFinal "100 min"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case 1: Option -end with a lot shorter time than in the data. \n"
printf " Test case 2: Weighting from separate SIF. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft

$PROGRAM -end=60 -d3 -min=0.009 -max=0.4 -thr=0 dynamic.v refdynamic.tac output_bp.v dynamic.sif > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt fittimeFinal "60 min"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.02 -rel=5 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n-------------------------------------------------------------------\n"

printf "\n 2.1.0 \n"
printf " Test case: Option -dvr. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_dvr.v output_dvr.dft stdout.txt
taccalc correct_bp.dft + 1 temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -dvr -min=0.009 -max=0.4 -thr=0 dynamic.v refdynamic.tac output_dvr.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_dvr.v test.roi output_dvr.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=2 temp.dft output_dvr.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-------------------------------------------------------------------\n"

printf "\n 2.2.0 \n"
printf " Test case: Optional other images are saved. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f output_bp.v output_bp.dft 
rm -f output_r1.v output_r1.dft 
rm -f output_k2.v output_k2.dft 
rm -f output_wss.v output_wss.dft 
rm -f output_err.v output_err.dft 

$PROGRAM -r1=output_r1.v -k2=output_k2.v -wss=output_wss.v -err=output_err.v -min=0.009 -max=0.4 -thr=0 dynamic.v refdynamic.tac output_bp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft output_bp.v test.roi output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.01 -rel=3 correct_bp.dft output_bp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft output_r1.v test.roi output_r1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=y -abs=0.05 -rel=5 correct_r1.tac output_r1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft output_k2.v test.roi output_k2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -yunit=n -abs=0.01 -rel=10 correct_k2.tac output_k2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft output_wss.v test.roi output_wss.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft output_err.v test.roi output_err.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption dynamic.v refdynamic.tac output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM dynamic.v refdynamic.tac output.v dynamic.sif extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM refdynamic.tac output.v  1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM refdynamic.tac output.v dynamic.sif 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dynamic.v output.v dynamic.sif 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 3.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.v refdynamic.tac output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dynamic.v nonexistingfile.tac output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dynamic.v refdynamic.tac output.v nonexistingfile.sif 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

