#!/bin/bash
#: Title      : test_imgbfh2om
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imgbfh2om$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f blood.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f lowmid.nii ] || [ ! -f correct_lowmid_flow.nii ]; then
  printf "\n Simulate low-to-mid range flow image with Vb=3 \n"
  b2t_h2o --silent      -voiname="f1" blood.dat   1 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f2" blood.dat   2 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f3" blood.dat   3 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f4" blood.dat   4 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f5" blood.dat   5 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f6" blood.dat   6 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f7" blood.dat   7 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f8" blood.dat   8 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f9" blood.dat   9 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f10" blood.dat  10 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f11" blood.dat  11 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f12" blood.dat  12 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f13" blood.dat  13 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f14" blood.dat  14 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f15" blood.dat  15 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f16" blood.dat  16 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f17" blood.dat  17 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f18" blood.dat  18 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f19" blood.dat  19 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f20" blood.dat  20 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f21" blood.dat  21 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f22" blood.dat  22 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f23" blood.dat  23 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f24" blood.dat  24 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f25" blood.dat  25 0.8 1 3 100 temp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe --silent temp.dft frames.dat lowmid.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy --silent -force lowmid.dft lowmid01 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=yes -mt="lowmid01" -x2=360 lowmid.svg -l blood.dat lowmid.dft
  tac2nii lowmid.dft 30 30 15 lowmid.nii masklowmid.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  printf "\n Make image with correct flow values \n"
  printf "180 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/(dL*min)\n" >> temp.dft
  tac2nii temp.dft 30 30 15 correct_lowmid_flow_dl.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct_lowmid_flow_dl.nii : 100 correct_lowmid_flow.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


if [ ! -f lowmid_va0.nii ]; then
  printf "\n Simulate low-to-mid range flow image with Vb=0 \n"
  b2t_h2o --silent      -voiname="f1" blood.dat   1 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f2" blood.dat   2 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f3" blood.dat   3 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f4" blood.dat   4 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f5" blood.dat   5 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f6" blood.dat   6 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f7" blood.dat   7 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f8" blood.dat   8 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f9" blood.dat   9 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f10" blood.dat  10 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f11" blood.dat  11 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f12" blood.dat  12 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f13" blood.dat  13 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f14" blood.dat  14 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f15" blood.dat  15 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f16" blood.dat  16 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f17" blood.dat  17 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f18" blood.dat  18 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f19" blood.dat  19 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f20" blood.dat  20 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f21" blood.dat  21 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f22" blood.dat  22 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f23" blood.dat  23 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f24" blood.dat  24 0.8 1 0 100 temp.dft
  b2t_h2o --silent -add -voiname="f25" blood.dat  25 0.8 1 0 100 temp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe --silent temp.dft frames.dat lowmid_va0.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy --silent -force lowmid_va0.dft lowmid02 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=yes -mt="lowmid02" -x2=360 lowmid_va0.svg -l blood.dat lowmid_va0.dft
  tac2nii lowmid_va0.dft 30 30 15 lowmid_va0.nii masklowmid_va0.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


if [ ! -f midhigh.nii ] || [ ! -f correct_midhigh_flow.nii ]; then
  printf "\n Simulate mid-to-high range flow image with Vb=3 \n"
  b2t_h2o --silent      -voiname="f30" blood.dat   30 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f40" blood.dat   40 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f50" blood.dat   50 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f60" blood.dat   60 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f70" blood.dat   70 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f80" blood.dat   80 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f90" blood.dat   90 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f100" blood.dat 100 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f110" blood.dat 110 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f120" blood.dat 120 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f130" blood.dat 130 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f140" blood.dat 140 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f150" blood.dat 150 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f160" blood.dat 160 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f170" blood.dat 170 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f180" blood.dat 180 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f190" blood.dat 190 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f200" blood.dat 200 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f220" blood.dat 220 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f240" blood.dat 240 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f260" blood.dat 260 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f280" blood.dat 280 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f300" blood.dat 300 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f350" blood.dat 350 0.8 1 3 100 temp.dft
  b2t_h2o --silent -add -voiname="f400" blood.dat 400 0.8 1 3 100 temp.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe --silent temp.dft frames.dat midhigh.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy --silent -force midhigh.dft midhigh01 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=yes -mt="midhigh01" -x2=360 midhigh.svg -l blood.dat midhigh.dft
  tac2nii midhigh.dft 30 30 15 midhigh.nii maskmidhigh.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  printf "\n Make image with correct flow values \n"
  printf "180 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200 220 240 260 280 300 350 400\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/(dL*min)\n" >> temp.dft
  tac2nii temp.dft 30 30 15 correct_midhigh_flow_dl.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct_midhigh_flow_dl.nii : 100 correct_midhigh_flow.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


if [ ! -f correct_va3.nii ] || [ ! -f correct_va3_dl.nii ] || [ ! -f correct_va0.nii ]; then
  printf "\n Make image with correct Va values \n"
  printf "180 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/dL\n" >> temp.dft
  tac2nii temp.dft 30 30 15 correct_va3_dl.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct_va3_dl.nii : 100 correct_va3.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  printf "180 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/dL\n" >> temp.dft
  tac2nii temp.dft 30 30 15 correct_va0.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_vd.nii ]; then
  printf "\n Make image with correct Vd values \n"
  printf "180 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8 0.8\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/mL\n" >> temp.dft
  tac2nii temp.dft 30 30 15 correct_vd.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f correct_lowmid_k2.nii ] || [ ! -f correct_midhigh_k2.nii ]; then
  printf "\n Make images with correct k2 values \n"
  imgcalc correct_lowmid_flow.nii : correct_vd.nii correct_lowmid_k2.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct_midhigh_flow.nii : correct_vd.nii correct_midhigh_k2.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Low-to-mid range flow. \n"
printf " Test case 2: Optional flow limit. \n"
printf " Test case 3: Additional parametric images saved. \n"
printf " Test case 4: Very large fit time. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -fmax=1 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat lowmid.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft flow.nii masklowmid.nii output.tsv
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 -rel=1 -frames=n correct_lowmid_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=1 -frames=n correct_va3.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.015 -rel=5 -frames=n correct_lowmid_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: mid-to-high range flow. \n"
printf " Test case 2: Optional flow limit. \n"
printf " Test case 3: Additional parametric images saved. \n"
printf " Test case 4: Very large fit time. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -fmin=0.2 -fmax=5 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat midhigh.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=1 -frames=n correct_midhigh_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0015 -rel=5 -frames=n correct_va3.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.25 -rel=5 -frames=n correct_midhigh_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Low-to-mid range flow with Va=0 in the data. \n"
printf " Test case 2: Optional flow limit but Va not fixed to zero. \n"
printf " Test case 3: Additional parametric images saved. \n"
printf " Test case 4: Very large fit time. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -fmax=1 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat lowmid_va0.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=1 -frames=n correct_lowmid_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0002 -rel=1 -frames=n correct_va0.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=5 -frames=n correct_lowmid_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Low-to-mid range flow with Va=0 in the data. \n"
printf " Test case 2: Optional flow limit and Va is fixed to zero. \n"
printf " Test case 3: Additional parametric images saved. \n"
printf " Test case 4: Very large fit time. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -fmax=1 -va=0 -k2=k2.nii -vd=vd.nii blood.dat lowmid_va0.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=1 -frames=n correct_lowmid_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=5 -frames=n correct_lowmid_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"



printf "\n 1.2.0 \n"
printf " Test case 1: mid-to-high range flow. \n"
printf " Test case 2: Optional k2 limits are set. \n"
printf " Test case 3: Additional parametric images saved. \n"
printf " Test case 4: Very large fit time. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -k2min=0.35 -k2max=5.3 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat midhigh.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=1 -frames=n correct_midhigh_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0015 -rel=5 -frames=n correct_va3.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.35 -rel=5 -frames=n correct_midhigh_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Option -dL. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii

$PROGRAM -dL -fmax=1 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat lowmid.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose flow.nii
imgmatch -abs=0.0001 -rel=1 -frames=n correct_lowmid_flow_dl.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose va.nii
imgmatch -abs=0.0001 -rel=1 -frames=n correct_va3_dl.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.015 -rel=5 -frames=n correct_lowmid_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Options -dL and -density. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f flow.nii va.nii k2.nii vd.nii
imgcalc correct_lowmid_flow_dl.nii : 1.1 test.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -dL -density=1.1 -fmax=1 -va=va.nii -k2=k2.nii -vd=vd.nii blood.dat lowmid.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose flow.nii
imgmatch -abs=0.0001 -rel=1 -frames=n test.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose va.nii
imgmatch -abs=0.0001 -rel=1 -frames=n correct_va3_dl.nii va.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=5 -frames=n correct_vd.nii vd.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.015 -rel=5 -frames=n correct_lowmid_k2.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.4.0 \n"
printf " Test case: Options -wss, -ee, and -bf. \n"
printf " Note: constraints are intentionally suboptimal to get contents to error image. \n"
printf " Expected result: Requested files are saved and readable by other SW.\n\n"

rm -f wss.nii err.nii bf.dft
rm -f wss.tif err.tif bf.svg

$PROGRAM -d3 -wss=wss.nii -err=err.nii -bf=bf.dft -fmin=0.05 -fmax=0.1 -pmin=0.75 -pmax=0.85 blood.dat lowmid.nii 99999 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2tif -rb wss.nii wss.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb err.nii err.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tac2svg -mt="Basis functions" bf.svg -l bf.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 1.5.0 \n"
printf " Test case: Input data is a little shorter than image. \n"
printf " Expected result: Results are close to correct. \n\n"

taccut blood.dat 0 340 test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f flow.nii

$PROGRAM -fmax=0.5 test.dat lowmid.nii 360 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose flow.nii
imgmatch -abs=0.00015 -rel=1.5 -header=n -frames=n correct_lowmid_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.1 \n"
printf " Test case: Input data is a lot shorter than image and fittime. \n"
printf " Expected result: Error. \n\n"

taccut blood.dat 0 240 test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f flow.nii stdout.txt

$PROGRAM -fmax=0.5 test.dat lowmid.nii 360 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftlist stdout.txt error
printf "\n passed. \n\n"



printf "\n 1.5.2 \n"
printf " Test case: Input data is a lot shorter than image but inside fittime. \n"
printf " Expected result: Results are close to correct. \n\n"

taccut blood.dat 0 240 test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f flow.nii output.ift

$PROGRAM -d2 -fmin=0.2 -fmax=5 test.dat midhigh.nii 240 flow.nii 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax -both --verbose flow.nii
imgmatch -abs=0.00015 -rel=1.5 -header=n -frames=n correct_midhigh_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n Checking that fittime was correctly set \n"
eframe -ift flow.nii output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift frame_start[1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift frame_duration[1] 4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.5.3 \n"
printf " Test case: Reduce fit time. \n"
printf " Expected result: Data inconsistency after fit time does not affect results. \n\n"

imgmove midhigh.nii -10 +10 21-22 movement.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f flow.nii

$PROGRAM -fmin=0.2 -fmax=5 blood.dat movement.nii 300 flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0002 -rel=2 -header=n -frames=n correct_midhigh_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.6.0 \n"
printf " Test case: Input data sample times are in minutes. \n"
printf " Expected result: Correct results are saved. \n\n"

cp -f blood.dat test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -xconv=min test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f flow.nii stdout.txt

$PROGRAM -d -fmax=0.5 test.dat lowmid.nii 9999 flow.nii 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=1 -header=n -frames=n correct_lowmid_flow.nii flow.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption blood.dat lowmid.nii 9999 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM blood.dat lowmid.nii 9999 flow.nii extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM  lowmid.nii 9999 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM blood.dat  9999 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM blood.dat lowmid.nii 9999  1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.bld lowmid.nii 9999 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM blood.dat nonexistingfile.nii 9999 flow.nii 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

