#!/bin/bash
#: Title      : test_imgbfk2
#: Date       : 2020-02-27
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None
#: Todo       : Error situations

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imgbfk2$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n creating data for testing \n"

if [ ! -f carfentanil_apc.fit ] || [ ! -f carfentanil_parentfract.fit ]; then
  rm -f carfentanil_apc.bld
  printf "FIT1        fit_sinf 0.6.15 (c) 2017 by Turku PET Centre\n" > carfentanil_apc.fit
  printf "Date:	2017-06-01 09:47:53\n" >> carfentanil_apc.fit
  printf "Data file:	unchanged.kbq\n" >> carfentanil_apc.fit
  printf "Data unit:	kBq/mL\n" >> carfentanil_apc.fit
  printf "Time unit:	min\n" >> carfentanil_apc.fit
  printf "Nr of VOIs:	1\n" >> carfentanil_apc.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> carfentanil_apc.fit
  printf "Plasma parent .	0.010	68.411	106	1.77E+002	12	0331	6.630630E-001	3.880988E-001	5.052719E-001	1.698325E-002	2.123866E+000	1.071961E-001	1.794217E+001	4.367584E-001	9.759633E+001	3.843467E+000	1.278706E+000	3.857623E-006\n" >> carfentanil_apc.fit

  printf "FIT1        fit_ppf 0.6.13 (c) 2017 by Turku PET Centre\n" > carfentanil_parentfract.fit
  printf "Date:	2017-03-22 10:30:49\n" >> carfentanil_parentfract.fit
  printf "Data file:	unchanged.rat\n" >> carfentanil_parentfract.fit
  printf "Data unit:	unitless\n" >> carfentanil_parentfract.fit
  printf "Time unit:	min\n" >> carfentanil_parentfract.fit
  printf "Nr of VOIs:	1\n" >> carfentanil_parentfract.fit
  printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> carfentanil_parentfract.fit
  printf "Parent . .	5.000	48.000	8	1.84E-003	5	0846	3.827078E-001	1.459124E+000	1.304178E+002	1.000000E+000	2.632742E+000\n" >> carfentanil_parentfract.fit
fi

if [ ! -f carfentanil_apc.bld ] || [ ! -f carfentanil_ab.bld ]; then
  printf "\n calculate input data for simulations \n"
  fit2dat -c=0,80,0.1 carfentanil_apc.fit carfentanil_apc.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  fit2dat -c=0,80,0.1 carfentanil_parentfract.fit carfentanil_parentfract.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  taccalc carfentanil_apc.bld div carfentanil_parentfract.bld carfentanil_ap.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tacunit -yset=kBq/mL carfentanil_ap.bld
  tacren carfentanil_ap.bld 1 Plasma total
  taccalc carfentanil_ap.bld - carfentanil_apc.bld carfentanil_apm.bld
  tacren carfentanil_apm.bld 1 Plasma metabolite
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  p2blood carfentanil carfentanil_ap.bld 0.40 carfentanil_ab.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tacren carfentanil_ab.bld 1 Blood
  tac2svg -mt="[11C]Carfentanil" -legend=y carfentanil_input.svg -l carfentanil_apc.bld carfentanil_apm.bld carfentanil_ap.bld carfentanil_ab.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f sim1.par ]; then
  printf "# model := 1TCM\n" > sim1.par
  printf "Parameters	K1[mL/(mL*min)]	k2[1/min]	Vb\n" >> sim1.par
  printf "tac1	0.4	0.6	0\n" >> sim1.par
  printf "tac2	0.3	0.2	0\n" >> sim1.par
fi

if [ ! -f cframes.sif ]; then
  rm -f sim1.tac
  printf "19/2/2020 19:41:52  31 4 1 TEST1 C-11\n" > cframes.sif
  printf "      0      20       0       0\n" >> cframes.sif
  printf "     20      25       0       0\n" >> cframes.sif
  printf "     25      30       0       0\n" >> cframes.sif
  printf "     30      35       0       0\n" >> cframes.sif
  printf "     35      40       0       0\n" >> cframes.sif
  printf "     40      45       0       0\n" >> cframes.sif
  printf "     45      50       0       0\n" >> cframes.sif
  printf "     50      55       0       0\n" >> cframes.sif
  printf "     55      60       0       0\n" >> cframes.sif
  printf "     60      65       0       0\n" >> cframes.sif
  printf "     65      70       0       0\n" >> cframes.sif
  printf "     70      75       0       0\n" >> cframes.sif
  printf "     75      80       0       0\n" >> cframes.sif
  printf "     80      90       0       0\n" >> cframes.sif
  printf "     90     120       0       0\n" >> cframes.sif
  printf "    120     150       0       0\n" >> cframes.sif
  printf "    150     180       0       0\n" >> cframes.sif
  printf "    180     210       0       0\n" >> cframes.sif
  printf "    210     240       0       0\n" >> cframes.sif
  printf "    240     300       0       0\n" >> cframes.sif
  printf "    300     360       0       0\n" >> cframes.sif
  printf "    360     420       0       0\n" >> cframes.sif
  printf "    420     540       0       0\n" >> cframes.sif
  printf "    540     660       0       0\n" >> cframes.sif
  printf "    660     960       0       0\n" >> cframes.sif
  printf "    960    1260       0       0\n" >> cframes.sif
  printf "   1260    1560       0       0\n" >> cframes.sif
  printf "   1560    2160       0       0\n" >> cframes.sif
  printf "   2160    2760       0       0\n" >> cframes.sif
  printf "   2760    3660       0       0\n" >> cframes.sif
  printf "   3660    4560       0       0\n" >> cframes.sif
fi


if [ ! -f sim1.bld ] || [ ! -f sim1.tac ] || [ ! -f sim1.svg ]; then
  rm -f sim1.v sim1b.v sim1b.tac
  printf "\n simulate TACs \n"
  sim_3tcm -nosub sim1.par carfentanil_apc.bld carfentanil_ab.bld sim1.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  simframe sim1.bld cframes.sif sim1.tac
  printf "\n ok \n"
  tac2svg -legend=y sim1.svg -s sim1.tac -l sim1.bld
  printf "\n ok \n"
fi

if [ ! -f sim1.v ] || [ ! -f correct_sim1_k1.v ] || [ ! -f correct_sim1_k2.v ] || [ ! -f correct_sim1_vt.v ]; then
  dft2img -scanner=HRRT -dim=4 -zoom=2.0 sim1.tac sim1.v sim1.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay --silent -i=C-11 -dc sim1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "\n Make images with correct parameter values \n"
  printf "2280 0.4 0.3\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/(mL*min)\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1_k1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "2280 0.6 0.2\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := 1/min\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1_k2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "2280 0.666667 1.5\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/mL\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1_vt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


if [ ! -f sim1b.bld ] || [ ! -f sim1b.tac ] || [ ! -f sim1b.svg ]; then
  rm -f sim1b.v sim1c.v
  printf "\n Add vascular blood contribution to simulated TACs \n"
  taccalc carfentanil_ab.bld x 0.08 temp.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc sim1.bld + temp.bld sim1b.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  simframe sim1b.bld cframes.sif sim1b.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  tac2svg -legend=y sim1b.svg -s sim1b.tac -l sim1b.bld
  printf "\n ok \n"
fi

if [ ! -f sim1b.v ] || [ ! -f correct_sim1b_vb.v ]; then
  rm -f sim1c.v
  dft2img -scanner=HRRT -dim=4 -zoom=2.0 sim1b.tac sim1b.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay --silent -i=C-11 -dc sim1b.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "\n Make images with correct parameter values \n"
  printf "2280 0.08 0.08\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/mL\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1b_vb.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi



if [ ! -f sim1c.v ] || [ ! -f correct_sim1c_k1.v ] || [ ! -f correct_sim1c_k2.v ] || [ ! -f correct_sim1c_vt.v ] || [ ! -f correct_sim1c_vb.v ]; then
  printf "\n Add blood into simulated image \n"
  simframe carfentanil_ab.bld cframes.sif carfentanil_ab.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr sim1c.tac sim1b.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd sim1c.tac carfentanil_ab.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HRRT -dim=4 -zoom=2.0 sim1c.tac sim1c.v sim1c.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay --silent -i=C-11 -dc sim1c.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "\n Make images with correct parameter values \n"
  printf "2280 0.08 0.08 1.0\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/mL\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1c_vb.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "2280 0.4 0.3 0\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/(mL*min)\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1c_k1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "2280 0.6 0.2 0\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := 1/min\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1c_k2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"

  printf "2280 0.666667 1.5 0\n" > temp.dft
  printf "# timeunit := sec\n" >> temp.dft
  printf "# unit := mL/mL\n" >> temp.dft
  dft2img -Scanner=HRRT -Dim=4 -zoom=2.0 temp.dft correct_sim1c_vt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Save K1 and k2 images. \n"
printf " Test case 2: Vb set to zero. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f k1.v k2.v vb.v vt.v

$PROGRAM -vbmin=0 -vbmax=0 carfentanil_apc.bld carfentanil_ab.bld sim1.v 99999 k1.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=2 correct_sim1_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=3 correct_sim1_k2.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Save K1 and Vt images. \n"
printf " Test case 2: Try to save Vb image although Vb is set to zero. \n"
printf " Expected result 1: Correct results calculated. \n"
printf " Expected result 2: Warning on Vb image. \n\n"

rm -f k1.v k2.v vb.v vt.v

$PROGRAM -vt=vt.v -vb=vb.v -vbmin=0 -vbmax=0 carfentanil_apc.bld carfentanil_ab.bld sim1.v 99999 k1.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=2 correct_sim1_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=3 correct_sim1_vt.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f vb.v ]; then  printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "Vb image will not be created."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case 1: Set tighter limits for K1 and k2. \n"
printf " Test case 2: Increase the number of basis functions. \n"
printf " Expected result: More precise results calculated. \n\n"

rm -f k1.v k2.v vb.v vt.v

$PROGRAM -vbmin=0 -vbmax=0 -k1max=1 -k2max=1 -nr=2000 carfentanil_apc.bld carfentanil_ab.bld sim1.v 99999 k1.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.5 correct_sim1_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.5 correct_sim1_k2.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Save K1, k2, and Vb images. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f k1.v vb.v k2.v vt.v

$PROGRAM -vb=vb.v carfentanil_apc.bld carfentanil_ab.bld sim1b.v 99999 k1.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=3 correct_sim1_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=3 correct_sim1_k2.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=1 correct_sim1b_vb.v vb.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Save K1 and Vt images. \n"
printf " Test case 2: Try to save Vb image although Vb is set to correct value. \n"
printf " Expected result 1: Correct results calculated. \n"
printf " Expected result 2: Warning on Vb image. \n\n"

rm -f k1.v k2.v vb.v vt.v

$PROGRAM -vt=vt.v -vb=vb.v -vbmin=0.08 -vbmax=0.08 carfentanil_apc.bld carfentanil_ab.bld sim1.v 99999 k1.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=3 correct_sim1_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=3 correct_sim1_vt.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f vb.v ]; then  printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "Vb image will not be created."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Image contains blood pool. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f k1.v vb.v k2.v vt.v

$PROGRAM -vb=vb.v -vt=vt.v -k2max=1 carfentanil_apc.bld carfentanil_ab.bld sim1c.v 99999 k1.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=3 correct_sim1c_k1.v k1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=3 correct_sim1c_k2.v k2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=1 correct_sim1c_vb.v vb.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.005 -rel=1 correct_sim1c_vt.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

