#!/bin/bash
#: Title      : test_imgflowd
#: Date       : 2023-05-24
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgflowd$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

if [ ! -f blood.fit ] || [ ! -f blood.bld ]; then
rm -f dyn.nii dyn2.nii
printf "FIT1        fit_sinf 0.6.19 (c) 2018 by Turku PET Centre\n" > blood.fit
printf "Date:	2018-02-12 09:00:05\n" >> blood.fit
printf "Data file:	lvcav.tac\n" >> blood.fit
printf "Data unit:	g/mL\n" >> blood.fit
printf "Time unit:	sec\n" >> blood.fit
printf "Nr of VOIs:	1\n" >> blood.fit
printf "Region Plane	Start	End	dataNr	WSS	parNr	Type	Parameters\n" >> blood.fit
printf "LV cav	0	290	1336	0	8	0331	7.856	11.54	5.697	1.384E-003	38	0.081	4.24	10\n" >> blood.fit

fit2dat -c=0,360,1 blood.fit blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg blood.svg -l blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f frames.sif ]; then
rm -f dyn.nii dyn2.nii
printf "22/10/2021 17:59:46  25 2 1 SIM1 O-15\n" > frames.sif
printf "0 5\n" >> frames.sif
printf "5 10\n" >> frames.sif
printf "10 15\n" >> frames.sif
printf "15 20\n" >> frames.sif
printf "20 25\n" >> frames.sif
printf "25 30\n" >> frames.sif
printf "30 35\n" >> frames.sif
printf "35 40\n" >> frames.sif
printf "40 45\n" >> frames.sif
printf "45 50\n" >> frames.sif
printf "50 55\n" >> frames.sif
printf "55 60\n" >> frames.sif
printf "60 65\n" >> frames.sif
printf "65 70\n" >> frames.sif
printf "70 80\n" >> frames.sif
printf "80 90\n" >> frames.sif
printf "90 100\n" >> frames.sif
printf "100 120\n" >> frames.sif
printf "120 140\n" >> frames.sif
printf "140 160\n" >> frames.sif
printf "160 190\n" >> frames.sif
printf "190 220\n" >> frames.sif
printf "220 250\n" >> frames.sif
printf "250 280\n" >> frames.sif
printf "280 310\n" >> frames.sif
fi

if [ ! -f sim.par ] || [ ! -f tissue.tac ] || [ ! -f dyn.nii ] || [ ! -f mask.nii ] || [ ! -f blood.tac ]; then
printf "# model := SER3TCM\n" > sim.par
printf "Parameters	K1[mL/(mL*min)]	K1/k2[mL/mL]	k3[1/min]	k3/k4	k5[1/min]	k5/k6	Vb[%%]	dT[sec]\n" >> sim.par
printf "tac1	2.0	0.8	0	0	0	0	0	0\n" >> sim.par
printf "tac2	1.0	0.8	0	0	0	0	0	0\n" >> sim.par
printf "tac3	0.5	0.8	0	0	0	0	0	0\n" >> sim.par
printf "tac4	0.2	0.8	0	0	0	0	0	0\n" >> sim.par
printf "tac5	2.0	0.8	0	0	0	0	0	-5\n" >> sim.par
printf "tac6	1.0	0.8	0	0	0	0	0	-5\n" >> sim.par
printf "tac7	0.5	0.8	0	0	0	0	0	-5\n" >> sim.par
printf "tac8	0.2	0.8	0	0	0	0	0	-5\n" >> sim.par
printf "tac9	2.0	0.8	0	0	0	0	0	10\n" >> sim.par
printf "tac10	1.0	0.8	0	0	0	0	0	10\n" >> sim.par
printf "tac11	0.5	0.8	0	0	0	0	0	10\n" >> sim.par
printf "tac12	0.2	0.8	0	0	0	0	0	10\n" >> sim.par

sim_3tcm sim.par blood.bld blood.bld tissue.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
simframe tissue.dat frames.sif tissue.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg tissue.svg -s tissue.tac -l tissue.dat blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

tac2nii tissue.tac 2 2 3 dyn.nii mask.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

simframe blood.bld frames.sif blood.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f delaymap.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > temp.tac
printf "0	0	0	0	0	0	-5	-5	-5	-5	10	10	10	10\n" >> temp.tac

tac2nii temp.tac 2 2 3 delaymap.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f truek1.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > k1.tac
printf "0	0	2	1	0.5	0.2	2	1	0.5	0.2	2	1	0.5	0.2\n" >> k1.tac
tac2nii k1.tac 2 2 3 truek1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f truek2.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > k2.tac
printf "0	0	2.5	1.25	0.625	0.25	2.5	1.25	0.625	0.25	2.5	1.25	0.625	0.25\n" >> k2.tac
tac2nii k2.tac 2 2 3 truek2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



if [ ! -f sim2.par ] || [ ! -f dyn2.nii ]; then
printf "# model := SER3TCM\n" > sim2.par
printf "Parameters	K1[mL/(mL*min)]	K1/k2[mL/mL]	k3[1/min]	k3/k4	k5[1/min]	k5/k6	Vb[%%]	dT[sec]\n" >> sim2.par
printf "tac1	2.0	0.8	0	0	0	0	10	0\n" >> sim2.par
printf "tac2	1.0	0.8	0	0	0	0	10	0\n" >> sim2.par
printf "tac3	0.5	0.8	0	0	0	0	10	0\n" >> sim2.par
printf "tac4	0.2	0.8	0	0	0	0	10	0\n" >> sim2.par
printf "tac5	2.0	0.8	0	0	0	0	10	-5\n" >> sim2.par
printf "tac6	1.0	0.8	0	0	0	0	10	-5\n" >> sim2.par
printf "tac7	0.5	0.8	0	0	0	0	10	-5\n" >> sim2.par
printf "tac8	0.2	0.8	0	0	0	0	10	-5\n" >> sim2.par
printf "tac9	2.0	0.8	0	0	0	0	10	10\n" >> sim2.par
printf "tac10	1.0	0.8	0	0	0	0	10	10\n" >> sim2.par
printf "tac11	0.5	0.8	0	0	0	0	10	10\n" >> sim2.par
printf "tac12	0.2	0.8	0	0	0	0	10	10\n" >> sim2.par

# Note the option -vvm=2 is used to comply to fit method
sim_3tcm -vvm=2 sim2.par blood.bld blood.bld tissue2.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
simframe tissue2.dat frames.sif tissue2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
tac2svg tissue2.svg -s tissue2.tac -l tissue2.dat blood.bld
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

tac2nii tissue2.tac 2 2 3 dyn2.nii mask.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f trueva.nii ]; then
printf "start[unknown]	end[seconds]	M1	M2	M3	M4	M5	M6	M7	M8	M9	M10	M11	M12\n" > va.tac
printf "0	0	0.1	0.1	0.1	0.1	0.1	0.1	0.1	0.1	0.1	0.1	0.1	0.1\n" >> va.tac
tac2nii va.tac 2 2 3 trueva.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Zero Va. \n"
printf " Test case 2: BTAC with frequent sampling. \n"
printf " Expected result: Close to correct K1 and k2 maps. \n\n"

rm -f output_k1.nii output_k1.tac
rm -f output_k2.nii output_k2.tac

$PROGRAM -Va=0 -k2=output_k2.nii blood.bld dyn.nii delaymap.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k1.nii mask.nii output_k1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k2.nii mask.nii output_k2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_k1.tac
taclist output_k2.tac

imgmatch -frames=no -abs=0.01 -rel=2 truek1.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=1 truek2.nii output_k2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Zero Va. \n"
printf " Test case 2: BTAC with image frames. \n"
printf " Expected result: Close to correct K1 and k2 maps. \n\n"

rm -f output_k1.nii output_k1.tac
rm -f output_k2.nii output_k2.tac

$PROGRAM -Va=0 -k2=output_k2.nii blood.tac dyn.nii delaymap.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k1.nii mask.nii output_k1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k2.nii mask.nii output_k2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_k1.tac
taclist output_k2.tac

imgmatch -frames=no -abs=0.01 -rel=5 truek1.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=5 truek2.nii output_k2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Data affected by Va and that is fitted. \n"
printf " Test case 2: BTAC with image frames. \n"
printf " Expected result: Close to correct Va, K1, and k2 maps. \n\n"

rm -f output_k1.nii output_k1.tac
rm -f output_k2.nii output_k2.tac
rm -f output_va.nii output_va.tac

$PROGRAM -Va=output_va.nii -k2=output_k2.nii blood.tac dyn2.nii delaymap.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k1.nii mask.nii output_k1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k2.nii mask.nii output_k2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_va.nii mask.nii output_va.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_k1.tac
taclist output_k2.tac
taclist output_va.tac

imgmatch -frames=no -abs=0.02 trueva.nii output_va.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=5 truek1.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=5 truek2.nii output_k2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Use delay map from imgdelay. \n"
printf " Test case 2: Va zero and frequent BTAC samples. \n"
printf " Expected result: Close to correct Va, K1, and k2 maps. \n\n"

rm -f output_k1.nii output_k1.tac
rm -f output_k2.nii output_k2.tac
rm -f output_dt.nii output_dt.tac

imgdelay dyn.nii blood.bld output_dt.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_dt.nii mask.nii output_dt.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_dt.tac

$PROGRAM -Va=0 -k2=output_k2.nii blood.bld dyn.nii output_dt.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k1.nii mask.nii output_k1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k2.nii mask.nii output_k2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_k1.tac
taclist output_k2.tac

imgmatch -frames=no -abs=0.01 -rel=1 truek1.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=1 truek2.nii output_k2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Use delay map from imgdelay. \n"
printf " Test case 2: Va included and BTAC with image frames. \n"
printf " Expected result: Close to correct Va, K1, and k2 maps. \n\n"

rm -f output_k1.nii output_k1.tac
rm -f output_k2.nii output_k2.tac
rm -f output_va.nii output_va.tac
rm -f output_dt.nii output_dt.tac

imgdelay dyn2.nii blood.tac output_dt.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_dt.nii mask.nii output_dt.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_dt.tac

$PROGRAM -Va=output_va.nii -k2=output_k2.nii blood.tac dyn2.nii output_dt.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k1.nii mask.nii output_k1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_k2.nii mask.nii output_k2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_va.nii mask.nii output_va.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist output_k1.tac
taclist output_k2.tac
taclist output_va.tac

imgmatch -frames=no -abs=0.05 trueva.nii output_va.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=10 truek1.nii output_k1.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=no -abs=0.01 -rel=5 truek2.nii output_k2.nii
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
