#!/bin/bash
#: Title      : test_imglhbdv
#: Date       : 2019-06-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None
#: Todo       : Error situations

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imglhbdv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f sim.par ]; then
  rm -f tissue.tac ttacs.tac tissue10.tac ttacs10.tac tissue50.tac ttacs50.tac
  printf "# model := 1TCM\n" > sim.par
  printf "Parameters	K1	K1/k2	Vb\n" >> sim.par
  printf "tac1	0.04	0.8	0\n" >> sim.par
  printf "tac2	0.04	0.8	0\n" >> sim.par
  printf "tac3	0.1	0.5	0\n" >> sim.par
  printf "tac4	0.2	1.5	0\n" >> sim.par
  printf "tac5	0.4	0.8	0\n" >> sim.par
  printf "tac6	0.5	10000	0\n" >> sim.par
  printf "tac7	0.04	10000	0\n" >> sim.par
  printf "tac8	0.2	15	0\n" >> sim.par
fi

if [ ! -f correct_vt.dat ]; then
# Note that by default Vt max is 1000
  printf "0	0.8	0.8	0.5	1.5	0.8	1000	1000	15\n" > correct_vt.dat
fi
if [ ! -f correct_vt_plus_vb.dat ]; then
# Note that by default Vt max is 1000
  printf "0	1.3	1.3	1.0	2.0	1.3	1000	1000	15.5\n" > correct_vt_plus_vb.dat
fi


if [ ! -f plasma.tac ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f tissue.tac ] || [ ! -f ttacs.tac ] || [ ! -f ttacs.svg ]; then
  rm -f dynamic.v dynamic10.v dynamic50.v
  rm -f ana/dynamic.* nii/dynamic.*

  printf "\n Simulate TTACs \n"
  sim_3tcm -d4 sim.par plasma.tac plasma.tac tissue.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n Add BTAC \n"
  taccalc plasma.tac . 0.10 temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc tissue.tac + temp.tac tissue10.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc plasma.tac . 0.50 temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc tissue.tac + temp.tac tissue50.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n Simulate PET frames \n"
  simframe tissue.tac frames.dat ttacs.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -y1=0 -mt="Simulated TTACs" ttacs.svg ttacs.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe tissue10.tac frames.dat ttacs10.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -y1=0 -mt="Simulated TTACs" ttacs10.svg ttacs10.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe tissue50.tac frames.dat ttacs50.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -y1=0 -mt="Simulated TTACs" ttacs50.svg ttacs50.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic.v ] || [ ! -f dynamic.roi ]; then
  rm -f ana/dynamic.* nii/dynamic.*
  printf "\n Simulate dynamic PET image \n"
  dft2img -scanner=hr+ -dim=32 -zoom=2.0 ttacs.tac dynamic.v dynamic.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2019-06-18 08:23:11
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f ana/dynamic.img ] || [ ! -f ana/dynamic.hdr ] || [ ! -f ana/dynamic.sif ]; then
  printf "\n Making Analyze images \n"
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f nii/dynamic.nii ] || [ ! -f nii/dynamic.sif ]; then
  printf "\n Making NIfTI images \n"
  ecat2nii -sif -o=nii dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f dynamic10.v ]; then
  printf "\n Simulate dynamic PET image with Vb 10\n"
  dft2img -scanner=hr+ -dim=32 -zoom=2.0 ttacs10.tac dynamic10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic10.v 2019-06-18 08:23:11
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic50.v ]; then
  printf "\n Simulate dynamic PET image with Vb 50 \n"
  dft2img -scanner=hr+ -dim=32 -zoom=2.0 ttacs50.tac dynamic50.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic50.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic50.v 2019-06-18 08:23:11
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




if [ ! -f blood.v ] || [ ! -f blood.roi ] || [ ! -f correct_blood_vb.dat ]; then
  rm -f temp.tac blood.roi correct_blood_vb.dat
  printf "\n Simulate dynamic PET image with only blood \n"
  taccalc plasma.tac . 0.10 temp1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc plasma.tac . 0.50 temp2.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc plasma.tac . 1.00 temp3.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc plasma.tac . 1.20 temp4.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr temp.tac temp1.tac temp2.tac temp3.tac temp4.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe temp.tac frames.dat btacs.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  dft2img -scanner=hr+ -dim=4 -zoom=2.0 btacs.tac blood.v blood.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc blood.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt blood.v 2019-06-18 14:21:47
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0	0.1	0.5	1.0	1.2\n" > correct_blood_vb.dat

fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Default settings. \n"
printf " Test case 3: No vascular volume in the data. \n"
printf " Expected result: Correct Vb and Vt images calculated. \n\n"

rm -f vb.v vt.v vb.tac vt.tac vb.ift vt.ift

$PROGRAM plasma.tac dynamic.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vb.v dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > output.txt
taclist vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 output.txt "vb.tac" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent vt.v dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

eframe -ift vb.v vb.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 vb.ift "frame_start[1]" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 vb.ift "frame_duration[1]" 120
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

eframe -ift vt.v vt.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 vt.ift "frame_start[1]" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 vt.ift "frame_duration[1]" 120
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case 1: Noiseless simulated Analyze image data. \n"
printf " Test case 2: Default settings. \n"
printf " Test case 3: No vascular volume in the data. \n"
printf " Expected result: Correct Vb and Vt images calculated. \n\n"

rm -f ana/vb.* ana/vt.* vb.tac vt.tac vb.ift vt.ift

$PROGRAM plasma.tac ana/dynamic ana/vb ana/vt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent ana/vb dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > output.txt
taclist vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 output.txt "vb.tac" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent ana/vt dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.2 \n"
printf " Test case 1: Noiseless simulated NIfTI image data. \n"
printf " Test case 2: Default settings. \n"
printf " Test case 3: No vascular volume in the data. \n"
printf " Expected result: Correct Vb and Vt images calculated. \n\n"

rm -f nii/vb.* nii/vt.* vb.tac vt.tac vb.ift vt.ift

$PROGRAM plasma.tac nii/dynamic nii/vb nii/vt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent nii/vb dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > output.txt
taclist vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 output.txt "vb.tac" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent nii/vt dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.1.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Default settings. \n"
printf " Test case 3: 10 percent vascular volume in the data. \n"
printf " Expected result: Correct Vb and Vt images calculated. \n\n"

rm -f vb.v vt.v vb.tac vt.tac vb.ift vt.ift

$PROGRAM plasma.tac dynamic10.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vb.v dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > output.txt
taclist vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.001 output.txt "vb.tac" 0.1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent vt.v dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Default settings. \n"
printf " Test case 3: 50 percent vascular volume in the data. \n"
printf " Expected result: Correct Vb and Vt images calculated. \n\n"

rm -f vb.v vt.v vb.tac vt.tac vb.ift vt.ift

$PROGRAM plasma.tac dynamic50.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vb.v dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > output.txt
taclist vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.002 output.txt "vb.tac" 0.5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent vt.v dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Image consists scaled BTACs. \n"
printf " Expected result: Correct Vb saved and Vt values are zeroes. \n\n"

rm -f vb.v vt.v vb.tac vt.tac

$PROGRAM plasma.tac blood.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vb.v blood.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vb.tac
tacmatch -abs=0.01 -rel=1 -x=n correct_blood_vb.dat vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent vt.v blood.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vt.tac > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
iftisval -abs=0.01 output.txt "vt.tac" 0.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Max Vt limited. \n"
printf " Expected result: Vt values are limited. \n\n"

rm -f vb.v vt.v output.ift

$PROGRAM -max=10 plasma.tac dynamic10.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax vt.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 output.ift max 10
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.4.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Threshold. \n"
printf " Expected result: Pixels with low TTACs are set to zero. \n\n"

rm -f vb.v vt.v vb.tac vt.tac output.ift

$PROGRAM -thr=100 plasma.tac dynamic10.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vb.v dynamic.roi vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftmax vb.tac > max.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
dftmax -min vb.tac > min.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
taclist vb.tac
iftisval -abs=0.001 max.txt "vb.tac" 0.1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 min.txt "vb.tac" 0.0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft --silent vt.v dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt.dat vt.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

taclist -ift vt.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.ift value[1][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.ift value[2][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.ift value[3][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.ift value[5][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.1 output.ift value[8][1] 15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n 1.5.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Vt optionally includes Vb. \n"
printf " Expected result: Correct Vt values. \n\n"

rm -f vb.v vt.v output.ift

$PROGRAM -withVb plasma.tac dynamic50.v vb.v vt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent vt.v dynamic.roi vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist vt.tac
tacmatch -abs=0.01 -rel=5 -x=n correct_vt_plus_vb.dat vt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

