#!/bin/bash
#: Title      : test_imglhdv
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imglhdv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f plasma.tac ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_vt.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



if [ ! -f orig.tac ] || [ ! -f dynamic.v ]; then
  rm -f origf.tac dynamic.v
  rm -f ana/dynamic.* nii/dynamic.*
  printf "\n Simulate TTACs \n"
  p2t_3c --silent -nosub plasma.tac 0.05	0.025	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.1	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.25	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.025	0.002	0.04 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.1	0.002	0.04 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.25	0.002	0.04 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.025	0.05	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.1	0.05	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.25	0.05	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.025	0.25	0.005 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.1	0.25	0.005 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.05	0.25	0.25	0.005 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.05	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.2	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.8	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.05	0.005	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.2	0.005	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.8	0.005	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.05	0.05	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.2	0.05	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.8	0.05	0.05 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.05	0.5	0.02 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.2	0.5	0.02 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.2	0.8	0.5	0.02 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.05	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.4	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.8	0	0 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.05	0.01	0.1 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.4	0.01	0.1 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.8	0.01	0.1 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.05	0.1	0.5 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.4	0.1	0.5 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.8	0.1	0.5 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.05	0.5	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.4	0.5	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  p2t_3c --silent -nosub plasma.tac 0.5	0.8	0.5	0.025 0 0 temp.tac
  tacadd --silent orig.tac temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f origf.tac ]; then
  rm -f dynamic.v
  rm -f ana/dynamic.* nii/dynamic.*
  printf "\n Simulate PET frames \n"
  simframe orig.tac frames.dat origf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren origf.tac 0 TAC#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -y1=0 -mt="Simulated TTACs" ttacs.svg origf.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic.v ]; then
  rm -f ana/dynamic.* nii/dynamic.*
  printf "\n Simulate dynamic PET image \n"
  dft2img -scanner=hr+ -dim=32 -zoom=2.0 origf.tac dynamic.v dv.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f ana/dynamic.img ] || [ ! -f ana/dynamic.hdr ] || [ ! -f ana/dynamic.sif ]; then
  printf "\n Making Analyze images \n"
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f nii/dynamic.nii ] || [ ! -f nii/dynamic.sif ]; then
  printf "\n Making NIfTI images \n"
  ecat2nii -sif -o=nii dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi



if [ ! -f correct_vt.v ]; then
  printf "\n Make parametric image containing correct Vt values \n"
  dft2img -scanner=hr+ -dim=32 -zoom=2.0 correct_vt.dat correct_vt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt correct_vt.v 2005-07-25 09:49:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_vt.v correct_vt.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft --silent correct_vt.v dv.roi correct_vt.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi





printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Default settings (AIC weighting). \n"
printf " Test case 3: Model weight image saved. \n"
printf " Expected result 1: Correct Vt image is calculated. \n"
printf " Expected result 2: Reasonable model weight image is calculated. \n\n"

rm -f output.v model.v output.dft output.ift model.ift

$PROGRAM -m=model.v plasma.tac dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent output.v dv.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent model.v dv.roi model.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=1 -abs=0.001 correct_vt.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

eframe -ift output.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift "frame_start[1]" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift "frame_duration[1]" 120
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmax -both model.v > model.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "max" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -lt model.ift min 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -gt model.ift min 0.999999
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Same as 1.0.0 but Analyze format. \n"
printf " Expected result: Correct Vt image is calculated. \n\n"

rm -f ana/output.* ana/model.*

$PROGRAM -m=ana/model plasma.tac ana/dynamic ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=1 -abs=0.001 correct_vt.v ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.2 \n"
printf " Test case: Same as 1.0.0 but NIfTI format. \n"
printf " Expected result: Correct Vt image is calculated. \n\n"

rm -f nii/output.* nii/model.*

$PROGRAM -m=nii/model plasma.tac nii/dynamic nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=1 -abs=0.001 correct_vt.v nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.1.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: AIC-selected model. \n"
printf " Test case 3: Model nr image saved. \n"
printf " Expected result 1: Correct Vt image is calculated. \n"
printf " Expected result 2: Reasonable model nr image is calculated. \n\n"

rm -f output.v model.v output.dft output.ift model.ift

$PROGRAM -a -m=model.v plasma.tac dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent output.v dv.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent model.v dv.roi model.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=2 -abs=0.01 correct_vt.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmax -both model.v > model.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "max" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "min" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Forced one-tissue model. \n"
printf " Test case 3: Model nr image saved. \n"
printf " Expected result 1: Reasonable Vt image is calculated. \n"
printf " Expected result 2: Correct model nr image is calculated. \n\n"

rm -f output.v model.v output.dft output.ift model.ift

$PROGRAM -1 -m=model.v plasma.tac dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent output.v dv.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent model.v dv.roi model.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=50 -abs=0.5 correct_vt.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmax -both model.v > model.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "max" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "min" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Forced one-tissue model. \n"
printf " Test case 3: Model nr image saved. \n"
printf " Expected result 1: Reasonable Vt image is calculated. \n"
printf " Expected result 2: Correct model nr image is calculated. \n\n"

rm -f output.v model.v output.dft output.ift model.ift

$PROGRAM -2 -m=model.v plasma.tac dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft --silent output.v dv.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent model.v dv.roi model.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=n -rel=2 -abs=0.01 correct_vt.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmax -both model.v > model.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "max" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 model.ift "min" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.0 \n"
printf " Test case 1: Noiseless simulated ECAT7 image data. \n"
printf " Test case 2: Max Vt limited. \n"
printf " Expected result: Vt values are limited. \n\n"

rm -f output.v output.dft output.ift

$PROGRAM -max=5 plasma.tac dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.00001 output.ift max 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption plasma.tac dynamic.v output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM plasma.tac dynamic.v output.v extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM plasma.tac dynamic.v   1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.tac dynamic.v output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM plasma.tac nonexistingfile.v output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Input files in wrong order. \n"
printf " Expected result: Error. \n\n"

$PROGRAM dynamic.v plasma.tac output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

