#!/bin/bash
#: Title      : test_imglhk1
#: Date       : 2021-12-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../imglhk1$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f fdg_arterial_plasma.fit ] || [ ! -f frames.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f k1k2vb.par ] || [ ! -f k1vb.par ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f true_k1.tac ] || [ ! -f true_vb.tac ] || [ ! -f true_k2.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f fdgplasma.tac ]; then
  rm -f k1k2vb.tac k1vb.tac
  printf "Making 10 min FDG PTAC with 0.05 min (3 s) sample intervals \n"
  fit2dat -c=0,10,0.01 fdg_arterial_plasma.fit fdgplasma.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f k1k2vb.tac ]; then
  rm -f k1k2vb.nii
  sim_3tcm -vvm=2 k1k2vb.par fdgplasma.tac fdgplasma.tac k1k2vb.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe k1k2vb.dat frames.sif k1k2vb.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f k1vb.tac ]; then
  rm -f k1vb.nii
  sim_3tcm -vvm=2 k1vb.par fdgplasma.tac fdgplasma.tac k1vb.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe k1vb.dat frames.sif k1vb.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f k1k2vb.nii ] || [ ! -f mask1.nii ]; then
  tac2nii k1k2vb.tac 16 16 16 k1k2vb.nii mask1.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f k1vb.nii ] || [ ! -f mask2.nii ]; then
  tac2nii k1vb.tac 16 16 16 k1vb.nii mask2.nii
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Estimate K1, Vb, and k2, using full data length. \n"
printf " Expected result: Correct parametric images are calculated. \n\n"

rm -f k1.nii k2.nii vb.nii

$PROGRAM fdgplasma.tac k1k2vb.nii k1.nii vb.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft k1.nii mask1.nii k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vb.nii mask1.nii vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft k2.nii mask1.nii k2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n--- Results for K1: \n"
taclist k1.tac
printf "\n--- Results for k2: \n"
taclist k2.tac
printf "\n--- Results for Vb: \n"
taclist vb.tac

tacmatch -abs=0.01 true_k1.tac k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 true_k2.tac k2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 true_vb.tac vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Estimate K1, k2, and Vb from data with k2=0 \n"
printf " Expected result: Close to correct parametric images are calculated. \n\n"

rm -f k1.nii k2.nii vb.nii

$PROGRAM fdgplasma.tac k1vb.nii k1.nii vb.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft k1.nii mask1.nii k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vb.nii mask1.nii vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n--- Results for K1: \n"
taclist k1.tac
printf "\n--- Results for Vb: \n"
taclist vb.tac

tacmatch -abs=0.01 true_k1.tac k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=001 true_vb.tac vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.0.0 \n"
printf " Test case: Estimate K1 and Vb, using full data length. \n"
printf " Expected result: Correct parametric images are calculated. \n\n"

rm -f k1.nii vb.nii

$PROGRAM fdgplasma.tac k1vb.nii k1.nii vb.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft k1.nii mask1.nii k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vb.nii mask1.nii vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n--- Results for K1: \n"
taclist k1.tac
printf "\n--- Results for Vb: \n"
taclist vb.tac

tacmatch -abs=0.01 true_k1.tac k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 true_vb.tac vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Estimate K1 and Vb, using limited data length. \n"
printf " Expected result: Correct parametric images are calculated. \n\n"

rm -f k1.nii vb.nii

$PROGRAM -end=3 fdgplasma.tac k1vb.nii k1.nii vb.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft k1.nii mask1.nii k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vb.nii mask1.nii vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n--- Results for K1: \n"
taclist k1.tac
printf "\n--- Results for Vb: \n"
taclist vb.tac

tacmatch -x=n -abs=0.01 true_k1.tac k1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -abs=0.001 true_vb.tac vb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -x=y -abs=0.01 true_k1.tac k1.tac
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0



