#!/bin/bash
#: Title      : test_imgfrdyn
#: Date       : 2019-11-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgfrdyn$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f original.tac ] || [ ! -f frdyn0.tac ] || [ ! -f frdyn1.tac ] || [ ! -f frdyn2.tac ] || [ ! -f frdyn3.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frdyn0.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdyn0.tac frdyn0.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frddyn1.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdyn1.tac frdyn1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frddyn2.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdyn2.tac frdyn2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f frddyn3.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 frdyn3.tac frdyn3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Default operation. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac

$PROGRAM original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdyn0.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 frdyn0.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Option -dmi. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac

$PROGRAM -dmi original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdyn1.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 frdyn1.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Option -incr. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac

$PROGRAM -incr original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdyn2.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 frdyn2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Option -decr. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac

$PROGRAM -decr original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n frdyn3.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 frdyn3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Option -noneg. \n"
printf " Expected result: Output image contains correct results. \n\n"

rm -f output.v output.tac
imgcutof frdyn1.v 0 9999 test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -noneg -dmi original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 test.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n\n"
printf "=====================================================================\n"
printf "testing for errors\n"
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Unknown option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption original.v output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n 2.1.0 \n"
printf " Test case 1: Image with just one frame. \n"
printf " Expected result: Error. \n\n"

$PROGRAM frdyn0.v output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "frdyn0.v contains only 1 time frame."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

