#!/bin/bash
#: Title      : test_imghist
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imghist$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f correct_100.tac ] || [ ! -f correct_100.tac ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f correct_130.tac ] || [ ! -f correct_152.tac ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi



printf "\n making test data \n"


if [ ! -f image.dat ] || [ ! -f image.v ]; then
rm -f image.bin image.v
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n"  > image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
printf "0.5 1.5 2.5 3.5 4.5 5.5 6.5 7.5\n" >> image.dat
fi

if [ ! -f image.v ] || [ ! -f image3d.v ] || [ ! -f image3d0.v ] || [ ! -f dynamic.v ]; then
  rm -f dynamic.v
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image.v 1 1 8 8 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=Bq/cc image.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image.v + 1 image2.v
  imgcalc image.v + 2 image3.v
  imgcalc image.v + 3 image4.v
  imgcalc image.v + 4 image5.v
  imgcalc image.v + 5 image6.v
  imgcalc image.v + 6 image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v image.v image2.v image3.v image4.v image5.v image6.v image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcalc image.v x 0 image0.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d0.v image0.v image.v image2.v image3.v image4.v image5.v image6.v image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi

if [ ! -f dynamic.v ] || [ ! -f pixels2.lst ]; then
  ecatcat image.v image2.v image3.v image4.v image5.v image6.v image7.v dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Static ECAT7 2D image. \n"
printf " Test case 2: Absolute bin size given. \n"
printf " Test case 3: Listing number of voxels in each bin. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_100.tac
$PROGRAM -d4 -bin=1.0 -nr -svg=output_100.svg image.v output_100.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_100.tac output_100.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Option -pos. \n"
printf " Expected result: No effect when all pixels are positive already. \n\n"

rm -f output_101.tac
$PROGRAM -d4 -bin=1.0 -nr -pos image.v output_101.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_100.tac output_101.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Negative voxel value included. \n"
printf " Test case 2: Option -pos not used. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_110.tac
imgcalc image.v - 1 test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tactime -keepnegat correct_100.tac -1 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -bin=1.0 -nr test.v output_110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 test.tac output_110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Negative voxel value included. \n"
printf " Test case 2: Option -pos. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_110.tac
tactime correct_100.tac -1 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -bin=1.0 -nr -pos test.v output_110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 test.tac output_110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case 1: Static ECAT7 3D image. \n"
printf " Test case 2: Absolute bin size given. \n"
printf " Test case 3: Listing number of voxels in each bin. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_120.tac
$PROGRAM -d4 -bin=1.0 -nr -svg=output_120.svg image3d.v output_120.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_120.tac output_120.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case 1: Dynamic ECAT7 2D image. \n"
printf " Test case 2: Absolute bin size given. \n"
printf " Test case 3: Listing number of voxels in each bin. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_130.tac
$PROGRAM -d4 -bin=1.0 -nr -svg=output_130.svg dynamic.v output_130.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_130.tac output_130.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.0 \n"
printf " Test case: Absolute bin size NOT given, but percentage of max. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_140.tac
$PROGRAM -d4 -nr -per=14.2857 image.v output_140.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_100.tac output_140.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.4.1 \n"
printf " Test case 1: Absolute bin size NOT given, but percentage of max. \n"
printf " Test case 2: Data includes negative voxels. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_141.tac
imgcalc image.v - 1 test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tactime -keepnegat correct_100.tac -1 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -nr -per=14.2857 test.v output_141.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.tac output_141.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.4.2 \n"
printf " Test case 1: Absolute bin size NOT given, but percentage of max. \n"
printf " Test case 2: Negative voxels excluded with -pos. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_142.tac
tactime correct_100.tac -1 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -nr -per=15.3846 -pos test.v output_142.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 test.tac output_142.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.5.0 \n"
printf " Test case 1: Fractional results, without option -nr. \n"
printf " Test case 2: No negative or zero pixel values. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_150.tac
taccalc correct_120.tac : 448 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -bin=1.0 image3d.v output_150.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.tac output_150.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.5.1 \n"
printf " Test case 1: Fractional results, without option -nr. \n"
printf " Test case 2: Image contains zero values which are excluded with -pos. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_151.tac
taccalc correct_120.tac : 448 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d4 -pos -bin=1.0 -svg=output_151.svg image3d0.v output_151.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 test.tac output_151.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.5.2 \n"
printf " Test case 1: Fractional results, without option -nr. \n"
printf " Test case 2: Image contains zero values. \n"
printf " Expected result: Correct histogram data extracted. \n\n"

rm -f output_152.tac

$PROGRAM -d4 -bin=1.0 -svg=output_152.svg image3d0.v output_152.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_152.tac output_152.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption image.v output.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM image.v output.tac extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -nr -pos 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.v output.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


