#!/bin/bash
#: Title      : test_imgmatch
#: Date       : 2019-11-19
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgmatch$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f frames.sif ]; then
  printf "18/11/2016 18:12:09 6 2 1 Test O-15\n" > frames.sif
  printf "  0  10\n" >> frames.sif
  printf " 10  20\n" >> frames.sif
  printf " 20  60\n" >> frames.sif
  printf " 60 120\n" >> frames.sif
  printf "120 240\n" >> frames.sif
  printf "240 480\n" >> frames.sif
fi

if [ ! -f data1.tac ]; then
  printf "start[seconds]	end[kBq/cc]	voi1	voi2	voi3	voi4\n" >  data1.tac
  printf "0.000	30.00	1	2	3	4\n" >>  data1.tac
  printf "30.00	60.00	5	6	7	8\n" >>  data1.tac
  printf "60.00	120.0	9	10	11	12\n" >>  data1.tac
fi
if [ ! -f data2.tac ]; then
  printf "start[seconds]	end[kBq/cc]	voi1	voi2	voi3	voi4\n" >  data2.tac
  printf "0.000	30.00	1	2	3	4.1\n" >>  data2.tac
  printf "30.00	60.00	5	6	7	8\n" >>  data2.tac
  printf "60.00	120.0	9	10.2	11	12\n" >>  data2.tac
fi

if [ ! -f image1.v ] || [ ! -f image2.v ]; then
  dft2img -dim=4 -scanner=hrrt data1.tac image2d1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=3 image1.v image2d1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -dim=4 -scanner=hrrt data2.tac image2d2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=3 image2.v image2d2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Image must match with itself. \n"
printf " Expected result: Match. \n\n"

$PROGRAM image1.v image1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Images must not match when different dimensions. \n"
printf " Expected result: No match. \n\n"

$PROGRAM image1.v image2d1.v
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Images must not match when different pixel values. \n"
printf " Expected result: No match. \n\n"

$PROGRAM image1.v image2.v
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case: Images with different pixel values match if difference is inside limits. \n"
printf " Expected result: Match. \n\n"

$PROGRAM -abs=0.3 image1.v image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -rel=3 image1.v image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case: Calculation of SS between images. \n"
printf " Expected result: Prints correct SS. \n\n"

rm -f stdout.txt

$PROGRAM -ss -abs=10 image1.v image2.v > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 stdout.txt SS 0.6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

