#!/bin/bash
#: Title      : test_imgpeak
#: Date       : 2019-09-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgpeak$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"



if [ ! -f original.tac ] || [ ! -f maxfr.tac ] || [ ! -f maxt.tac ] || [ ! -f maxct.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f maxv.tac ] || [ ! -f maxv_thr.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f maxfr.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 maxfr.tac maxfr.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f maxt.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 maxt.tac maxt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f maxct.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 maxct.tac maxct.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f maxv.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 maxv.tac maxv.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f maxv_thr.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 maxv_thr.tac maxv_thr.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_mpt.tac ]; then
  printf "time[seconds]\tMean[Bq/cc]\t-SD\t+SD\n"    > correct_mpt.tac
  printf "5400\t1.000e+03\t1.000e+03\t1.000e+03\n"  >> correct_mpt.tac
  printf "18000\t5.000e+01\t5.000e+01\t5.000e+01\n" >> correct_mpt.tac
  printf "90000\t6.000e+02\t6.000e+02\t6.000e+02\n" >> correct_mpt.tac
fi


if [ ! -f radiowater.fit ] || [ ! -f radiowater.bld ] || [ ! -f radiowater.svg ]; then
  rm -f radiowater.tac radiowater.v
  printf "FIT1\tfit_winp 0.2.0  (c) 2010 by Turku PET Centre\n" > radiowater.fit
  printf "Date:\t2010-09-19 19:19:34\n" >> radiowater.fit
  printf "Data file:\tradiowater.bld\n" >> radiowater.fit
  printf "Data unit:\tkBq/mL\n" >> radiowater.fit
  printf "Time unit:\tsec\n" >> radiowater.fit
  printf "Nr of VOIs: 9\n" >> radiowater.fit
  printf "Region\tStart\tEnd\tdataNr\tWSS\tparNr\tType\tParameters\n"         >> radiowater.fit
  printf "Blood1\t0.0\t360\t360\t0\t6\t0331\t0.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood2\t0.0\t360\t360\t0\t6\t0331\t1.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood3\t0.0\t360\t360\t0\t6\t0331\t2.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood4\t0.0\t360\t360\t0\t6\t0331\t3.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood5\t0.0\t360\t360\t0\t6\t0331\t4.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood6\t0.0\t360\t360\t0\t6\t0331\t5.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood7\t0.0\t360\t360\t0\t6\t0331\t6.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood8\t0.0\t360\t360\t0\t6\t0331\t7.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit
  printf "Blood9\t0.0\t360\t360\t0\t6\t0331\t8.7\t15\t600\t0.07\t85\t0.002\n" >> radiowater.fit

  fit2dat -c=0,61,0.1 radiowater.fit radiowater.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -mt="" radiowater.svg -l radiowater.bld
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f radiowater.sif ] || [ ! -f radiowater.tac ] || [ ! -f radiowaterf.svg ]; then
  rm -f radiowater.v

  printf "26/5/2018 13:54:01 12 2 1  \n" > radiowater.sif
  printf "0 5\n"   >> radiowater.sif
  printf "5 10\n"  >> radiowater.sif
  printf "10 15\n" >> radiowater.sif
  printf "15 20\n" >> radiowater.sif
  printf "20 25\n" >> radiowater.sif
  printf "25 30\n" >> radiowater.sif
  printf "30 35\n" >> radiowater.sif
  printf "35 40\n" >> radiowater.sif
  printf "40 45\n" >> radiowater.sif
  printf "45 50\n" >> radiowater.sif
  printf "50 55\n" >> radiowater.sif
  printf "55 60\n" >> radiowater.sif

  simframe radiowater.bld radiowater.sif radiowater.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y -mt="" radiowaterf.svg -l radiowater.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f radiowater.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=16 radiowater.tac radiowater.v radiowater.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic image in ECAT 7 format. \n"
printf " Test case 2: Option -frame, no peak file name given. \n"
printf " Expected result: Output image contain correct frame numbers. \n\n"

rm -f output.v output.tac

$PROGRAM -thr=0 -frame=output.v original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 maxfr.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n maxfr.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Save maximum value image. \n"
printf " Expected result: Output image contains correct maximum values. \n\n"

rm -f outputmax.v outputmax.tac

$PROGRAM -thr=0 original.v outputmax.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft outputmax.v original.roi outputmax.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=1 maxv.v outputmax.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: Save both peak values and frame numbers. \n"
printf " Expected result: Output images contains correct values. \n\n"

rm -f output.v outputmax.v

$PROGRAM -thr=0 -frame=output.v original.v outputmax.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 maxfr.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=1 maxv.v outputmax.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Save normalized maximum value image. \n"
printf " Expected result: Output image contains correct maximum values. \n\n"

rm -f outputmax2.v outputmax2.tac outputmax2.ift

$PROGRAM -thr=0 -norm original.v outputmax2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft outputmax2.v original.roi outputmax2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift outputmax2.tac > outputmax2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 outputmax2.ift value[1][1] 3.883
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval outputmax2.ift value[2][1] 3.871
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval outputmax2.ift value[3][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval outputmax2.ift value[4][1] 0.8
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Save mean TAC of peak values versus peak times. \n"
printf " Expected result: Correct TAC saved. \n\n"

rm -f output.tac

$PROGRAM -thr=0 -mpt=output.tac original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 correct_mpt.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case: Option -time. \n"
printf " Expected result: Output image contains correct frame mid times. \n\n"

rm -f output.v output.tac

$PROGRAM -thr=0 -time=output.v original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n maxt.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 maxt.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Option -ct. \n"
printf " Expected result: Output image contains correct weighted times. \n\n"

rm -f output.v output.tac

$PROGRAM -thr=0 -ct=output.v original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=1 -rel=1 -tacnames=n maxct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 maxct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 3.0.0 \n"
printf " Test case: Option -wt. \n"
printf " Expected result: Output image contains correct times. \n\n"

rm -f output.v output.tac
tacpeak -wt radiowater.tac temp.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
paradd -ovr -par=2 test.res temp.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


$PROGRAM -thr=0 -wt=output.v radiowater.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v radiowater.roi output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dft2res output.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
parmatch -parnames=n -parunits=n -tacnames=n -abs=0.1 -rel=1 test.res output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 4.0.0 \n"
printf " Test case 1: Let program use the default threshold. \n"
printf " Test case 2: No pixels affected by threshold limit. \n"
printf " Expected result: Output not affected by thresholding. \n\n"

$PROGRAM -thr=0 -frame=output_fr0.v -wt=output_wt0.v radiowater.v output0.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -frame=output_fr1.v -wt=output_wt1.v radiowater.v output1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 output0.v output1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 output_fr0.v output_fr1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 output_wt0.v output_wt1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.0 \n"
printf " Test case: Set threshold level to 10 percent. \n"
printf " Expected result: Correct peak values thresholded. \n\n"

$PROGRAM -thr=10 original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.001 maxv_thr.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

