#!/bin/bash
#: Title      : test_imgprofi
#: Date       : 2018-02-13
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgprofi$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f basic.dat ] || [ ! -f basic.header ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f frame.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f true_xpro1.dat ] || [ ! -f true_ypro1.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f true_xpro2.dat ] || [ ! -f true_ypro2.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f true_xpro3.dat ] || [ ! -f true_ypro3.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f true_xpro4.dat ] || [ ! -f true_ypro4.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi
if [ ! -f true_zpro1.dat ] || [ ! -f true_zpro2.dat ]; then
  printf "Failed: required data file does not exist.\n"
  exit 1
fi



printf "\n making test data \n"

if [ ! -f test.v ] || [ ! -f test.tif ]; then
  rm -f test2.v test3.v testz.v
  asc2flat basic.dat basic.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=hr+ -zoom=2.5 basic.bin test.v 1 1 12 12
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7evhdr test.v basic.header
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -us=kBq/ml test.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt test.v 2009-12-18 14:17:04
  img2tif -rb -s test.v test.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.v ] || [ ! -f test2.tif ]; then
  rm -f test3.v
  imgcalc test.v x 1.1 temp01.v
  imgcalc test.v x 1.2 temp02.v
  imgcalc test.v x 1.3 temp03.v
  imgcalc test.v x 1.5 temp04.v
  imgcalc test.v x 1.4 temp05.v
  imgcalc test.v x 1.25 temp06.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd test2.v test.v temp0?.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f temp0?.v
  img2tif -rb -s test2.v test2.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test3.v ] || [ ! -f test3.tif ]; then
  imgcalc test2.v x 2  temp01.v
  imgcalc test2.v x 10 temp02.v
  imgcalc test2.v x 5  temp03.v
  imgcalc test2.v x 4  temp04.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat test2.v temp01.v temp02.v temp03.v temp04.v test3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe test3.v frame.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f temp0?.v
  img2tif -rb -s test3.v test3.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f testz.v ]; then
  imgcalc test.v x 2  temp01.v
  imgcalc test.v x 10 temp02.v
  imgcalc test.v x 3  temp03.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=5  temp04.v test.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=10 temp05.v temp01.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd -x=5  temp06.v temp03.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd testz.v temp04.v temp05.v temp02.v temp06.v temp04.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f temp0?.v
  img2tif -rb -s testz.v testz.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case 1: 2D image matrix. \n"
printf " Test case 2: Pixel given with option -pxl. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output.tif x.pro y.pro

$PROGRAM -tif=output.tif -pxl=1,1,1 test.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output100.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_xpro1.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_ypro1.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: 2D image matrix. \n"
printf " Test case 2: Pixel given with option -pxlfile. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

printf "1,1,1\n" > test.pxl
rm -f x.pro y.pro

$PROGRAM -pxlfile=test.pxl test.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output101.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_xpro1.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_ypro1.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: 2D image matrix. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output2.tif x.pro y.pro

$PROGRAM -tif=output2.tif test.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output110.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_xpro2.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_ypro2.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case 1: 2D image matrix. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Test case 3: Option -focus. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f x.pro y.pro
tactime -keepnegat true_xpro2.dat -4.5 testx.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tactime -keepnegat true_ypro2.dat -4.5 testy.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -focus test.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output111.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 testx.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 testy.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: 3D image. \n"
printf " Test case 2: Pixel given with option -pxl. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output3.tif x.pro y.pro
taccalc true_xpro1.dat x 1.1 xtest.dat
taccalc true_ypro1.dat x 1.1 ytest.dat

$PROGRAM -tif=output3.tif -pxl=1,1,2 test2.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output120.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 xtest.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 ytest.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case 1: 3D image. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output4.tif x.pro y.pro
taccalc true_xpro2.dat x 1.5 xtest.dat
taccalc true_ypro2.dat x 1.5 ytest.dat

$PROGRAM -tif=output4.tif test2.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output121.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 xtest.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 ytest.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"








printf "\n 1.3.0 \n"
printf " Test case 1: 4D image. \n"
printf " Test case 2: Pixel given with option -pxl. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output5.tif x.pro y.pro

$PROGRAM -tif=output5.tif -pxl=1,1,5 test3.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output130.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_xpro3.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_ypro3.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.3.1 \n"
printf " Test case 1: 4D image. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f output6.tif x.pro y.pro

$PROGRAM -tif=output6.tif test3.v x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output131.svg -l x.pro y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_xpro4.dat x.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_ypro4.dat y.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Z-profile from 3D image. \n"
printf " Test case 2: Pixel given with option -pxl. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f outputz.tif x.pro y.pro z.pro xyz.svg

$PROGRAM -tif=outputz.tif -pxl=7,7,16 testz.v x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y xyz.svg -l x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_zpro1.dat z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case 1: Z-profile from 3D image. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f x.pro y.pro z.pro xyzmax.svg

$PROGRAM testz.v x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y xyzmax.svg -l x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 true_zpro2.dat z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.2 \n"
printf " Test case 1: Z-profile from 3D image. \n"
printf " Test case 2: Program is allowed to search the max pixel. \n"
printf " Test case 3: Option -focus. \n"
printf " Expected result: Correct profiles data extracted. \n\n"

rm -f x.pro y.pro z.pro xyzmaxfocus.svg
tactime -keepnegat true_zpro2.dat -6.0625 testz.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -focus testz.v x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y xyzmaxfocus.svg -l x.pro y.pro z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.001 -rel=0.1 testz.dat z.pro
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption test2.v output1.tac output2.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test2.v output1.tac output2.tac output3.tac extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test2.v output1.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.v output1.tac output2.tac 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
