#!/bin/bash
#: Title      : test_imgaumc
#: Date       : 2019-09-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgaumc$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f original.tac ] || [ ! -f correct.tac ] || [ ! -f correct_ln.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f original_gap.tac ] || [ ! -f original_lap.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=4 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f correct.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=4 correct.tac correct.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f original_gap.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=4 original_gap.tac original_gap.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f original_lap.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=4 original_lap.tac original_lap.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct AUMCs. \n\n"

rm -f output.v output.tac

$PROGRAM original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Dynamic image has gap between frames. \n"
printf " Expected result: Output image contain correct AUMCs. \n\n"

rm -f output.v output.tac

$PROGRAM original_gap.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Dynamic image has overlapping frames. \n"
printf " Expected result: Output image contain correct AUMCs. \n\n"

rm -f output.v output.tac

$PROGRAM original_lap.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 correct.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Option -log. \n"
printf " Expected result: Output image contain correct log transformed AUMCs. \n\n"

rm -f output.v output.tac

$PROGRAM -log original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n correct_ln.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Option -MRT. \n"
printf " Expected result: Output image contain correct MRTs. \n\n"

rm -f output_aumc.v output_mrt.tac

$PROGRAM original.v output_aumc.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -mrt original.v output_mrt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_mrt.v original.roi output_mrt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imginteg original.v 0 0 temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc output_aumc.v DIV temp.v test.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft test.v original.roi test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output_mrt.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imgmatch -abs=0.1 -rel=0.1 test.v output_mrt.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

