#!/bin/bash
#: Title      : test_imgcutof
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgcutof$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f test_dyn.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f dynamic.v ] || [ ! -f dynamic.img ]; then
  rm -f static.v
  
  dft2img -scanner=HR+ -zoom=2 -dim=8 test_dyn.tac dynamic.v dynamic.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 dynamic.v dynamic.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f ana/dynamic.*
  rmdir ana
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f nifti/dynamic.*
  rmdir nifti
  ecat2nii -sif -o=nifti dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f static.v ] || [ ! -f static.img ]; then
  imginteg -avg dynamic.v 0 0 static.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imginteg -avg dynamic.img 0 0 static.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imginteg -avg ana/dynamic 0 0 ana/static
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imginteg -avg nifti/dynamic 0 0 nifti/static
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f lower.lim ] || [ ! -f upper.lim ]; then
  printf "0\n"  > lower.lim
  printf "40\n" > upper.lim
fi

if [ ! -f limits.ift ]; then
  printf "lower_limit :=  0\n"  > limits.ift
  printf "upper_limit := 40\n" >> limits.ift
fi



if [ ! -f mask.v ]; then
  printf "0 0 0 0 0 0\n"  > mask.dat
  printf "0 1 1 1 1 1\n" >> mask.dat
  printf "0 1 2 2 2 2\n" >> mask.dat
  printf "0 1 2 3 3 3\n" >> mask.dat
  printf "0 1 2 3 4 4\n" >> mask.dat
  printf "0 1 2 3 4 5\n" >> mask.dat
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 6 6
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_mask.v ]; then
  printf "0 0 0 0 0 0\n"  > correct_mask.dat
  printf "0 1 1 1 1 1\n" >> correct_mask.dat
  printf "0 1 1 1 1 1\n" >> correct_mask.dat
  printf "0 1 1 1 1 1\n" >> correct_mask.dat
  printf "0 1 1 1 0 0\n" >> correct_mask.dat
  printf "0 1 1 1 0 0\n" >> correct_mask.dat
  asc2flat correct_mask.dat correct_mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_mask.bin correct_mask.v 1 1 6 6
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case 1: Set limits 0 and 90. \n"
printf " Test case 2: Dynamic ECAT 7 format. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM dynamic.v 0 90 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Set limits 0 and 90. \n"
printf " Test case 2: Dynamic ECAT 6.3 format. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.img output.ift
$PROGRAM dynamic.img 0 90 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.img > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Set limits 0 and 90. \n"
printf " Test case 2: Dynamic NIfTI image format. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f nifti/output.nii output.ift
$PROGRAM nifti/dynamic.nii 0 90 nifti/output.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both nifti/output.nii > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case 1: Set limits 0 and 90. \n"
printf " Test case 2: Dynamic Analyze image format. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f ana/output.img ana/output.hdr ana/output.sif output.ift
$PROGRAM ana/dynamic 0 90 ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both ana/output > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"

printf "\n 1.1.0 \n"
printf " Test case 1: Sum image can be thresholded. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f sumoutput.v
$PROGRAM static.v 0 40 sumoutput.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both sumoutput.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.1 \n"
printf " Test case: Limits can be given as only contents of two files. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f sumoutput.v
$PROGRAM static.v lower.lim upper.lim sumoutput.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both sumoutput.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Limits can be given in key files with appropriate key names. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f sumoutput.v
$PROGRAM static.v limits.ift limits.ift sumoutput.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both sumoutput.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 1.2.0 \n"
printf " Test case 1: Limit only high values. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM dynamic.v -99999 90 output.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min -1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.2.1 \n"
printf " Test case 1: Limit only low values. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM dynamic.v 0 999999 output.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 1000
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 1.3.0 \n"
printf " Test case: Overwrite original image. \n"
printf " Expected result: Correct image saved. \n\n"

cp -f dynamic.v test.v
rm -f output.v output.ift
$PROGRAM test.v 0 90  
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both test.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 90
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: No pixels outside limits. \n"
printf " Expected result: Image not saved. \n\n"

rm -f output.v output.ift
$PROGRAM dynamic.v -99999 9999999 output.v  
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ -f output.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.2 \n"
printf " Test case: No pixels outside limits, but option --force. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM --force dynamic.v -99999 9999999 output.v  
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch dynamic.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"


printf "\n 1.4.0 \n"
printf " Test case 1: Option -zero. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM -zero dynamic.v 0 90 output.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 50
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.1 \n"
printf " Test case 1: Option -zero. \n"
printf " Test case 2: Mask image. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.ift
$PROGRAM -zero mask.v 1 3 output.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmax -both output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift max 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.ift min 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

imgmask mask.v correct_mask.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgmatch -abs=0.0001 temp.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 1.5.0 \n"
printf " Test case: Option -mask with mask image. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v
$PROGRAM -mask mask.v 1 3 output.v 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 output.v correct_mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption dynamic.v 0 90 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM dynamic.v 0 90 output.v extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM   0 90 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dynamic.v 0  1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM dynamic.v 90 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM nonexistingfile.v 0 90 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case: Invalid limits. \n"
printf " Expected result: Error. \n\n"

$PROGRAM dynamic.v 90 60 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
