#!/bin/bash
#: Title      : test_imgdelfr
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdelfr$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f original.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ] || [ ! -f original.img ]; then
  rm -f ana/* nii/*
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 -c=o original.v original.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f ana/original.img ] || [ ! -f ana/original.hdr ]; then
  rm -f ana/*
  ecat2ana -sif -o=ana original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nii/original.nii ] || [ ! -f nii/original.sif ]; then
  rm -f nii/*
  ecat2nii -sif -o=nii original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Delete frame nr 1. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.v output.tac
taccut original.tac 60 1800 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM original.v 1 1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Delete frame nr 1 with times in sec. \n"
printf " Test case 2: Dynamic image in ECAT 6.3 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.img output.tac

$PROGRAM -sec original.img 0 60 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.img original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Delete frame nr 1 with times in min. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.v output.tac

$PROGRAM -min original.v 0 1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Delete frame nr 7-8. \n"
printf " Test case 2: Dynamic image in ECAT 6.3 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.img output.tac
taccut original.tac 0 600 test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM original.img 7 8 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.img original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Delete frame nr 7-8 with times in sec. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.v output.tac

$PROGRAM -sec original.v 600 99999 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Delete frame nr 3-4. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f output.v output.tac
taccut original.tac 0 120 temp1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccut original.tac 360 1800 temp2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
dftcat temp1.tac temp2.tac test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM original.v 3 4 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Delete frame nr 3-4. \n"
printf " Test case 2: Dynamic image in NIfTI-1 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f nii/output.* output.tac

$PROGRAM nii/original 3 4 nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.2 \n"
printf " Test case 1: Delete frame nr 3-4. \n"
printf " Test case 2: Dynamic image in Analyze format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f ana/output.* output.tac

$PROGRAM ana/original 3 4 ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Set to zero frame nr 3-4. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct pixel values. \n\n"

rm -f output.v output.tac
cp -f original.tac test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacsety test.tac 1 3 0
tacsety test.tac 2 3 0
tacsety test.tac 3 3 0
tacsety test.tac 4 3 0
tacsety test.tac 1 4 0
tacsety test.tac 2 4 0
tacsety test.tac 3 4 0
tacsety test.tac 4 4 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -zero original.v 3 4 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Set to zero frame nr 3-4. \n"
printf " Test case 2: Dynamic image in NIfTI-1 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f nii/output.* output.tac

$PROGRAM -zero nii/original 3 4 nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case 1: Set to zero frame nr 3-4. \n"
printf " Test case 2: Dynamic image in Analyze format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f ana/output.* output.tac

$PROGRAM -zero ana/original 3 4 ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case 1: Set to zero frame nr 3-4 with times in sec. \n"
printf " Test case 2: Dynamic image in ECAT 7 format. \n"
printf " Expected result: Output image contain correct pixel values. \n\n"

rm -f output.v output.tac

$PROGRAM -zero -sec original.v 120 360 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "... and times in min\n\n"
rm -f output.v output.tac

$PROGRAM -zero -min original.v 2 6 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=y -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case 1: Set to zero frame nr 3-4 with times in min. \n"
printf " Test case 2: Dynamic image in NIfTI-1 format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f nii/output.* output.tac

$PROGRAM -zero -min nii/original 2 6 nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.2 \n"
printf " Test case 1: Set to zero frame nr 3-4 with times in sec. \n"
printf " Test case 2: Dynamic image in Analyze format. \n"
printf " Expected result: Output image contain correct frames. \n\n"

rm -f ana/output.* output.tac

$PROGRAM -sec -zero ana/original 120 360 ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=n -yunit=n -abs=0.1 -rel=1 -tacnames=n test.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"



printf "\n 3.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f output.v
$PROGRAM -stupidoption -sec original.v 120 360 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -sec original.v 120 360 output.v extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -sec  120 360 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sec original.v  360 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sec original.v 120 360   1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -sec nonexistingfile.v 120 360 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.2.0 \n"
printf " Test case: Invalid frame range. \n"
printf " Expected result: Error. \n\n"

$PROGRAM original.v 4 3 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM original.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM original.v 100 200 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.1 \n"
printf " Test case: Invalid frame time range. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -sec original.v 100 20 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sec original.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sec original.v 70 70 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -min original.v 1000 2000 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

