#!/bin/bash
#: Title      : test_imgledif
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgledif$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f data1.tac ] || [ ! -f data1.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2\n" > data1.tac
  printf "0.0	2.0	0.100	0.200\n" >> data1.tac
  printf "2.0	4.0	0.100	0.200\n" >> data1.tac
  printf "4.0	8.0	0.200	0.100\n" >> data1.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 data1.tac data1.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Subtract early frames from late frame. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] -0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Subtract late frames from early frame. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -el data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] -0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Subtract early frames from late frame. \n"
printf " Test case 2: Save absolute values. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -abs data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Subtract late frames from early frame. \n"
printf " Test case 2: Save absolute values. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -el -abs data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case: Subtract early frames from late frame. \n"
printf " Test case 2: Set negatives to zero. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -noneg data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Subtract late frames from early frame. \n"
printf " Test case 2: Set negatives to zero. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -el -noneg data1.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Overlapping frame range. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -frames data1.v 3 1 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f output.v output.tac

$PROGRAM -frames -el data1.v 3 1 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Subtract early times from late times. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -LE data1.v 4 4 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] -0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Subtract late times from early times. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -EL data1.v 4 4 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] -0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Subtract early times from late times. \n"
printf " Test case 2: Partial frames. \n"
printf " Test case 3: Saving early and late images. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -LE -efile=output1.v -lfile=output2.v data1.v 1 6 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output1.v data.roi output1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output2.v data.roi output2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output1.tac
cat output2.tac
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] 0.15
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.0
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Subtract late times from early times. \n"
printf " Test case 2: Partial frames. \n"
printf " Test case 3: Saving early and late images. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v output.tac

$PROGRAM -EL -efile=output1.v -lfile=output2.v data1.v 3 6 output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output1.v data.roi output1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output2.v data.roi output2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft --silent output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output1.tac
cat output2.tac
cat output.tac
iftisval -abs=0.000001 output.ift value[1][1] -0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.000001 output.ift value[2][1] 0.1
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n"
printf "=====================================================================\n"
printf "testing for errors\n"
printf "=====================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case 1: Unknown option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption data1.v 4 4 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n 3.1.0 \n"
printf " Test case 1: Static image. \n"
printf " Expected result: Error. \n\n"

imginteg -avg -min data1.v 0 8 static.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM static.v 1 1 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "static.v is static image."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n 3.2.0 \n"
printf " Test case: Invalid early times. \n"
printf " Expected result: Error. \n\n"

$PROGRAM data1.v -1 6 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid early time '-1'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM data1.v 0 6 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid early time '0'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM -frames data1.v 0 2 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid early frame '0'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM data1.v 10 6 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid early time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n 3.2.1 \n"
printf " Test case: Invalid late times. \n"
printf " Expected result: Error. \n\n"

$PROGRAM data1.v 2 -1 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid late time '-1'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM data1.v 2 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid late time '0'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM -frames data1.v 2 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid late frame '0'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM data1.v 2 10 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid late time."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


