#!/bin/bash
#: Title      : test_imgmask
#: Date       : 2016-09-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgmask$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0\n"  > mask.dat
printf "0 2 2 2 2 2 2 2 2 2 2 2 2 1 2 0\n" >> mask.dat
printf "0 2 1 1 1 1 1 1 1 1 1 1 1 1 2 0\n" >> mask.dat
printf "0 2 1 2 2 2 2 2 2 2 2 0 2 0 2 0\n" >> mask.dat
printf "0 2 1 2 0 0 0 0 0 0 0 0 2 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 2 2 2 0 2 2 2 2 0 2 0\n" >> mask.dat
printf "0 2 0 0 0 0 0 2 0 2 0 0 2 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 0 2 0 0 0 0 2 2 0 2 0\n" >> mask.dat
printf "0 2 0 0 2 0 2 2 2 2 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 2 0 2 0 0 0 2 0 0 0 0 2 2 0\n" >> mask.dat
printf "0 2 0 0 2 2 2 0 2 0 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 0 2 2 0 0 0 2 0 0 0 0 2 2 0\n" >> mask.dat
printf "0 2 0 0 2 2 2 2 2 2 2 2 0 0 2 0\n" >> mask.dat
printf "0 2 2 0 0 0 0 0 0 0 0 2 2 2 2 0\n" >> mask.dat
printf "0 2 2 2 2 2 2 2 2 2 0 2 2 2 2 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f image.dat ] || [ ! -f image.v ]; then
rm -f image.bin image.v
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n"  > image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n" >> image.dat
fi

if [ ! -f image.bin ] || [ ! -f image.v ] || [ ! -f image3d.v ]; then
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v image.v image.v image.v image.v image.v image.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: No options. \n"
printf " Test case 2: Single matrix of mask and pet image. \n"
printf " Expected result: Correctly masked. \n\n"

cp -f image.v output.v
$PROGRAM output.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_0_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc mask.v : mask.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgmatch -abs=0.01 temp.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Output image name given as additional argument. \n"
printf " Expected result 1: Input image not overwritten. \n"
printf " Expected result 2: Output written in new file. \n\n"

rm -f output.v
cp -f image.v input.v
$PROGRAM input.v mask.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch image.v input.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 temp.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Option -inv. \n"
printf " Expected result: Correctly masked. \n\n"

cp -f image.v output2.v
$PROGRAM -inv output2.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output2.v output_1_1_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc output.v + output2.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif temp.v output_1_1_0b.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgmatch -abs=0.01 image.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case: Mask applied to all planes of pet image. \n"
printf " Expected result: Correctly masked. \n\n"

cp -f image3d.v output.v
$PROGRAM output.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v output_1_2_0.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgcalc mask.v : mask.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgadd temp3d.v temp.v temp.v temp.v temp.v temp.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

imgmatch -abs=0.01 temp3d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


