#!/bin/bash
#: Title      : test_fit_sinf
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fit_sinf$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


if [ ! -f ../ptac/c11-carfentanil_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/c11-flumazenil_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/c11-mp4b_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/c11-raclopride_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/c11-way100635_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/f18-choline_metabcorr.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f ../ptac/f18-fbpa_totplasma.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/f18-fdg_arteriaplasma.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/f18-fdg_venaplasma.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/f18-fdopa_metabcor.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-h2o_muscle.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-h2o_onkol.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-o2_metabcorr_delaycorr_muscle.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-o2_totblood_brain.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-o2_totblood_muscle.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-h2o_blo1.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f ../ptac/o15-h2o_blo2.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Typical carfentanil PTAC. \n"
printf " Test case 2: SVG plot of fit can be saved. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=c11-carfentanil_metabcorr

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=20 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,10,20,50 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,10,20,50 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.2 -rel=1 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Typical flumazenil PTAC. \n"
printf " Test case 2: SVG plots of start and end part can be saved. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=c11-flumazenil_metabcorr

$PROGRAM -wf -svg1=$fname'1.svg' -svg2=$fname'2.svg' -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'1.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'2.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=4 -rel=30 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,20,40,90 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,20,40,90 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=2 -rel=15 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Typical MP4A PTAC. \n"
printf " Test case 2: func number can be set to 5. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=c11-mp4b_metabcorr

$PROGRAM -n=5 -wf -svg1=$fname'1.svg' -svg2=$fname'2.svg' -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'1.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'2.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=10 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,15,40 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,15,40 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case: Typical raclopride PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=c11-raclopride_metabcorr

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=10 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,15,40 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,15,40 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.4 \n"
printf " Test case: Typical WAY100635 PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=c11-way100635_metabcorr

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=10 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,15,40 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,15,40 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.5 \n"
printf " Test case: Typical 18F-choline PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=f18-choline_metabcorr

$PROGRAM -wf -svg=$fname'.svg' -svg1=$fname'1.svg' -svg2=$fname'2.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=40 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,20,60,100 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,20,60,100 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.6 \n"
printf " Test case: Typical FBPA PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=f18-fbpa_totplasma

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=10 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=3,15,40 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=3,15,40 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.7 \n"
printf " Test case: Typical FDG arterial PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=f18-fdg_arteriaplasma

$PROGRAM -wf -svg=$fname'.svg' -svg1=$fname'1.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=6 -rel=20 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=5,15,60 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=5,15,60 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.8 \n"
printf " Test case: Typical FDG venous PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=f18-fdg_venaplasma

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=2 -rel=25 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=5,20,50 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=5,20,50 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=2 -rel=15 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.9 \n"
printf " Test case: Typical FDOPA PTAC. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=f18-fdopa_metabcor

$PROGRAM -wf -svg=$fname'.svg' -svg1=$fname'1.svg' -svg2=$fname'2.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=5 -rel=20 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=5,30,90,200 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=5,30,90,200 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Radiowater BTAC from muscle study. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=o15-h2o_muscle

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=150 -rel=90 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=60,180,360 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=60,180,360 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=100 -rel=20 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Radiowater BTAC from oncology study. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat
fname=o15-h2o_onkol

$PROGRAM -wf -svg=$fname'.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=150 -rel=90 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=60,180,440 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=60,180,440 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=100 -rel=20 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Typical radiowater BTAC with dispersion correction. \n"
printf " Expected result 1: Good fitting result. \n"
printf " Expected result 2: Dispersion corrected and non-corrected BTACs can be saved. \n\n"

rm -f output.fit output_dcfit.dat output_nondcfit.dat
fname=o15-h2o_blo1
$PROGRAM -tau1=5.0 -tau2=2.5 -fit=output_nondcfit.dat -dcfit=output_dcfit.dat '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg $fname'.svg' -s '../ptac/'$fname'.kbq' -l output_dcfit.dat output_nondcfit.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=50,100,360 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=50,100,360 output_nondcfit.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n the same except that BTAC has one outlier sample. \n"
rm -f output.fit output_dcfit.dat output_nondcfit.dat
fname=o15-h2o_blo2
$PROGRAM -tau1=5.0 -tau2=2.5 -fit=output_nondcfit.dat -dcfit=output_dcfit.dat '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg $fname'.svg' -s '../ptac/'$fname'.kbq' -l output_dcfit.dat output_nondcfit.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=50,100,360 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=50,100,360 output_nondcfit.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.3 \n"
printf " Test case: Corrected only for dispersion in tubing (tau2). \n"
printf " Expected result 1: Good fitting result. \n"
printf " Expected result 2: Dispersion corrected and non-corrected BTACs can be saved. \n\n"

rm -f output.fit output_dcfit.dat output_nondcfit.dat
fname=o15-h2o_blo1
$PROGRAM -tau2=2.5 -fit=output_nondcfit.dat -dcfit=output_dcfit.dat '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg $fname'.tau2.svg' -s '../ptac/'$fname'.kbq' -l output_dcfit.dat output_nondcfit.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=50,100,360 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=50,100,360 output_nondcfit.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=1 -rel=10 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: O2-study for muscle. \n"
#printf " Test case 2: Dispersion correction. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat correct.dat temp.dat
fname=o15-o2_metabcorr_delaycorr_muscle

$PROGRAM -svg=$fname'.svg' -svg1=$fname'1.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=100 -rel=50 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=60,180,440 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=60,180,440 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=100 -rel=20 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: O2-study for brain. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat correct.dat temp.dat
fname=o15-o2_totblood_brain

$PROGRAM -svg=$fname'.svg' -svg1=$fname'1.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=50 -rel=30 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=60,180,300 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=60,180,300 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=100 -rel=20 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.2 \n"
printf " Test case: O2-study for muscle. \n"
printf " Expected result: Good fitting result. \n\n"

rm -f output.fit output.dat correct.dat temp.dat
fname=o15-o2_totblood_muscle

$PROGRAM -svg=$fname'.svg' -svg1=$fname'1.svg' '../ptac/'$fname'.kbq' output.fit
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f $fname'.svg' ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
fit2dat -f='../ptac/'$fname'.kbq' output.fit output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=50 -rel=30 '../ptac/'$fname'.kbq' output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
interpol -i -x=60,180,450 '../ptac/'$fname'.kbq' correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=60,180,450 output.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=100 -rel=20 correct.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n\n===============================================================\n"
printf "   Tests for error handling \n"
printf "===============================================================\n\n"


printf "\n 2.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat
fname=c11-carfentanil_metabcorr

$PROGRAM -stupidoption '../ptac/'$fname'.kbq' output.fit 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat
fname=c11-carfentanil_metabcorr

$PROGRAM '../ptac/'$fname'.kbq' output.fit extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Nonexisting data file. \n"
printf " Expected result: Appropriate error message and error code returned. \n\n"

rm -f output.fit output.dat

$PROGRAM nonexistingfile.dat output.fit 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

