#!/bin/bash
#: Title      : test_sim_o2bl
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../sim_o2bl$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f blood.kbq ] || [ ! -f blood_o.kbq ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test1234_blo.kbq ] || [ ! -f test1234wb.bld ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f correct_water.kbq ] || [ ! -f correct_oxygen.kbq ]; then
  p2t_3c -sub blood.kbq 1.307e-03 1.307e-03 2.034e-03 0 0 0 temp.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr --force correct_water.kbq temp.dat 2
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc --force blood.kbq - correct_water.kbq correct_oxygen.kbq
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f par.ift ]; then
  printf "k1 := 1.307e-03\n"     > par.ift
  printf "k1+k3 := 3.341e-03\n" >> par.ift
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Normal usage with default settings. \n"
printf " Expected result: Correct oxygen BTACs. \n\n"

rm -f output.kbq
$PROGRAM blood_o.kbq par.ift output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct_water.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Parameters saved with current version of fit_o2bl. \n"
printf " Expected result: Works with parameters from fit_o2bl. \n\n"

rm -f output.res output1.kbq output2.kbq output.kbq
fit_o2bl -model=k4 -k3k4=1 test1234_blo.kbq test1234wb.bld output.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
o2metab test1234_blo.kbq output.res output1.kbq output2.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output1.kbq output.res output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg test1234.svg -l test1234_blo.kbq output1.kbq output2.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=0.5 output2.kbq output.kbq
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n"
printf "=====================================================================\n"
printf "error testing for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n"

$PROGRAM -stupidoption blood_o.kbq par.ift output.kbq 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Extra argument entered. \n"
printf " Expected result: Error. \n"

$PROGRAM blood_o.kbq par.ift output.kbq extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments: 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Missing argument(s). \n"
printf " Expected result: Error. \n"

$PROGRAM blood_o.kbq par.ift 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n"

$PROGRAM nonexistingfile.dat par.ift output.kbq 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nonexistingfile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n"

$PROGRAM blood_o.kbq nonexistingfile.dat output.kbq 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot read 'nonexistingfile.dat'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




rm -f *.bak
printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
