/// @file libtpcidi.h
/// @brief Header file for libtpcidi.
/// @author Vesa Oikonen
///
/*****************************************************************************/
#ifndef _LIBTPCIDI_H
#define _LIBTPCIDI_H
/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
//#include <omp.h>
/*****************************************************************************/
#include "libtpcmisc.h"
#include "libtpcmodel.h"
#include "libtpcsvg.h"
#include "libtpccurveio.h"
#include "libtpcimgio.h"
#include "libtpcimgp.h"
#include "libtpcmodext.h"
/*****************************************************************************/

/*****************************************************************************/
/* circle.c */
extern int imgCircleMask(
  IMG *img, int zi, double cx, double cy, double r, double mv, double *smv, 
  int verbose
);
extern int imgRingMask(
  IMG *img, int zi, double cx, double cy, double r1, double r2, double mv,
  double *smv, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* heart.c */
extern int imgSimulateRing(
  IMG *img, int fi, int zi, double cx, double cy, 
  double r1, double r2, double vr, double vi, double vo,
  int verbose
);
extern int simMyocDiameterCurve(
  DFT *dft, double t1, double t2, double hbr, double maxdiam, double mindiam
);
extern int imgSimulateSphere(
  IMG *img, int fi, double cx, double cy, double cz, 
  double r1, double r2, double vr, double vi, double vo,
  int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* heartcorr.c */
/// @cond
extern int heartcorr(
  int verbose
);
/// @endcond
extern int heartRecoverySpilloverCorrectionFactors(
  double R, double d, double s, double Vb,
  double *FMM, double *FMB, double *FBM, double *FBB
);
/*****************************************************************************/

/*****************************************************************************/
/* idimask.c */
extern int imgMaskPixelTACs(IMG *img, IMG *mask, double thrs, DFT *dft, int verbose);
/*****************************************************************************/

/*****************************************************************************/
/* peak.c */
extern int imgGetConcWeightedPeakPos(
  IMG *img, float thrs, IMG_PIXEL *pos, int verbose
);
/*****************************************************************************/

/*****************************************************************************/
/* recovery.c */
extern double rcPeakPET(double FWHM, double R);
/*****************************************************************************/

/*****************************************************************************/
/* vessel.c */
extern int idiSimulateTubeVol(
  VOL *vol, int zi, double cx, double cy, double r, double FWHM,
  double cbkg, double cblo
);
extern int idiSimulateTubeImg(
  IMG *img, int zi, double cx, double cy, double r, double *cbkg, double *cblo
);
extern int idiSimulateTubeImgPlane(
  int simmet, IMG *img, int zi, double cx, double cy, double r, double FWHM,
  double *cbkg, double *cblo
);
/*****************************************************************************/

/*****************************************************************************/
#endif /* _LIBTPCIDI_H */
