/// @file libtpcroi.h
/// @brief Header file for libtpcroi.
/// @author Vesa Oikonen
///
#ifndef _LIBTPCROI_H
#define _LIBTPCROI_H
/*****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <ctype.h>
#include <time.h>
/*****************************************************************************/
#include "libtpcmisc.h"
#include "libtpcimgio.h"
/*****************************************************************************/

/*****************************************************************************/
#ifndef BACKUP_EXTENSION
/** Backup file extension */
#define BACKUP_EXTENSION ".bak"
#endif 
/*****************************************************************************/
/** The ROI library error message */
extern char roierrmsg[128];
/*****************************************************************************/
/** Definition for ROI types */
#define ROI_RECTANGULAR 0
/** Definition for ROI types */
#define ROI_CIRCULAR 1
/** Definition for ROI types */
#define ROI_ELLIPSE 2
/** Definition for ROI types */
#define ROI_TRACE 3
/*****************************************************************************/
/** ROI data structure */
typedef struct {
  /** Image file for which the ROIs have been defined */
  char imgfile[FILENAME_MAX];
  /** Zoom of the image when ROI was drawn; actually integer, although stored as float. */
  float zoom;
  /** Image reconstruction zoom; truly a float. */
  float recon_zoom;
  /** Matrix number (plane and frame) where ROI was defined */
  int matnum;
  /** Type of ROI (ROI_RECTANGULAR, ROI_CIRCULAR,...) */
  int type;
  /** ROI status */
  int status;
  /** ROI initial point x, relative to top left corner of the image. */
  int pos_x;
  /** ROI initial point y, relative to top left corner of the image */
  int pos_y;
  /** ROI width for other than trace ROIs. */
  int w;
  /** ROI height for other than trace ROIs. */
  int h;
  /** t is unused. */
  int t;
  /** Number of ROI */
  int roi;
  /** ROI name as specified when drawing */
  char roiname[256];
  /** ROI line definition for trace ROIs; used only if type is ROI_TRACE,
      otherwise x and y should be NULL. */
  int *x;
  /** ROI line definition for trace ROIs; used only if type is ROI_TRACE,
      otherwise x and y should be NULL. */
  int *y;
  /** ROI line definition for trace ROIs; used only if type is ROI_TRACE,
      otherwise x and y should be NULL. */
  int point_nr;
  /** User data. Used only by client programs */
  void *userdata;
} ROI;

/** A doubly linked list for ROIs by CL */
typedef struct _RoiList {
  /** Pointer to ROI */
  ROI *roi;
  /** Next */
  struct _RoiList *next;
  /** Previous */
  struct _RoiList *prev;
} RoiList;

/** Definition for a set of ROIs (deprecated) */
typedef struct {
  /** Linked list for ROIs */
  RoiList *rois;
  /** Number of ROIs in list; Deprecated, use the above linked list instead */
  int nr;
/// @cond
  /** Allocated memory for _allocNr ROIs*/
  int _allocNr;
/// @endcond
  /** List of the rois (deprecated) */
  ROI *roi;
} ROI_list;
/*****************************************************************************/

/*****************************************************************************/
/* ecat_roi */
/* Initialize a ROI_list structure */
extern void roi_init(ROI_list *rl);

/* Delete all ROIs from a ROI_list */
extern void roi_empty(ROI_list *rl);

/* Delete a single ROI from ROI_list, pointed by pointer *roi */
extern void roi_delete(ROI_list *rl,ROI *roi);

/* Delete a single ROI from ROI_list, pointed by index number */
extern void roi_delete_n(ROI_list *rl,int index);

/* Read ROIs from file. They are appended to ROI_list  */
extern int roi_read(const char *fname,ROI_list *rl);

/* Save all ROIs from ROI_list overwriting the existing file */
extern int roi_save(const char *fname, ROI_list *rl); 

/* Append a single ROI into stream *fp */
extern int roi_append(FILE *fp,ROI *roi);

/* Append a single ROI to stream *fp from ROI_list, pointed by index. 
  (indexes start from 0 */
extern int roi_append_n(FILE *fp, ROI_list *rl, int ind); 

extern int roi_onoff(ROI *roi, int dimx, int dimy, char **m);

extern int roi_compute_rect(ROI *roi);
extern int roi_compute_circle(ROI *roi);
extern int roi_compute_ellipse(ROI *roi);
extern void roi_print(ROI *roi);
extern int jsqrt(int n);

extern int roi_mplane(int matnum);
extern int roi_mframe(int matnum);
/*****************************************************************************/

/*****************************************************************************/
/* ecat_roi_old */

/** Deprecated function name */
#define roiEmpty roi_empty
/** Deprecated function name */
#define roiInit roi_init
/** Deprecated function name */
#define roiPrint roi_print

extern void roiDel(ROI_list *rl, int ind); /* Delete one ROI from list, */
extern int roiComputeRect(ROI *roi);
extern int roiComputeCirc(ROI *roi);
extern int roiComputeElli(ROI *roi);
extern int roiRead(const char *fname, ROI_list *rl);
extern int roiFillGaps(int *x, int *y, int nr, int **ffx, int **ffy);
extern int roiOnOff(ROI *roi, int dimx, int dimy, char **m);
extern void roiOnOffPrint(int dimx, int dimy, char **m);
extern int roiSave(const char *fname, ROI_list *rl); /* Save all ROIs in list */
extern int roiAppend(char *fname, ROI_list *rl, int ind); 
/*****************************************************************************/

/*****************************************************************************/
#endif // _LIBTPCROI_H
