/******************************************************************************
 * This file is not compiled into the library, but it contains main()
 * which is compiled to an executable, used to test the library functions. 
 *****************************************************************************/

/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "libtpcmisc.h"
#include "libtpcsvg.h"
/*****************************************************************************/
#include <unistd.h>
/*****************************************************************************/

/*****************************************************************************/
//#define MAX_TICK_NR 20
extern int AXIS_TEST;

int test_axis_tick_positions()
{
  printf("\n=====================================\n");
  printf("\n%s\n", __func__);
  printf("\n=====================================\n");

  int nr, ret;
  double begin, end, ticks[MAX_TICK_NR], scalef;
  int ticdec;

  begin=0; end=10; nr=8;
  printf("Test #1: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=0; end=2; nr=8;
  printf("Test #2: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=41; end=42; nr=8;
  printf("Test #3: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=41.1; end=41.2; nr=8;
  printf("Test #4: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=41.11111111; end=41.11111116; nr=8;
  printf("Test #5: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=-20; end=1; nr=5;
  printf("Test #6: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=-19; end=4; nr=5;
  printf("Test #7: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=-23; end=777777777; nr=6;
  printf("Test #8: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}

  begin=0.000006; end=0.000018; nr=10;
  printf("Test #9: begin=%g end=%g max_nr=%d\n", begin, end, nr);
  ret=axis_tick_positions(begin, end, ticks, &nr, &scalef, &ticdec, 2);
  if(ret) {fprintf(stderr, "Error %d\n", ret); return(1);}


  /*
0-10                      -> 0, 2, 4, 6, 8, 10
0-2                       -> 0.0, 0.5, 1.0, 1.5, 2.0
41-42                     -> 41.0, 41.2, 41.4, 41.6, 41.8, 42.0
41.1-41.2                 -> 41.10, 41.12, 41.14, 41.16, 41.18, 41.20
41.11111111 - 41.11111116 -> 41.11111114
-20 - 1                   -> -20, -10, 0
-19 - 4                   -> -15, -10, -5, 0
-23 - 777777777           -> 0e+8, 2e+8, 4e+8, 6e+8
0.000006 - 0.000018       -> 0.6, 0.8, 1.0, 1.2, 1.4, 1.6, 1.8 x e-5 
  */
  
  return(0);
}
/******************************************************************************/

/*****************************************************************************/
static char *info[] = {
  "Usage: @P [options]",
  " ",
  "Options:",
  " -stdoptions", // List standard options like --help, -v, etc
  " -t, --test",
  "     Run all tests for library functions.",
  0};
/*****************************************************************************/

/*****************************************************************************/
/** Run unit tests to the library functions
 *  @author Vesa Oikonen
 *  @return 0 if all tests pass, otherwise >0.
 * */
int main(
  /** Nr of arguments */
  int argc,
  /** Pointer to arrays of argument string */
  char *argv[ ]
) {
  int i, help=0, version=0, verbose=1, error=0, test=0;
  int ret;
  char *cptr;

  if(argc==1) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  for(i=1; i<argc; i++) {
    if(tpcProcessStdOptions(argv[i], &help, &version, &verbose)==0) continue;
    cptr=argv[i]; if(*cptr=='-') cptr++; if(*cptr=='-') cptr++;
    if(strncasecmp(cptr, "TEST", 1)==0) {
      test=1; continue;
    } else {
      error++; break;
    }
  }
  if(error>0) {
    fprintf(stderr, "Error: specify --help for usage.\n");
    return(1);
  }
  /* Print help or version? */
  if(help) {tpcPrintUsage(argv[0], info, stdout); return(0);}
  if(version) {tpcPrintBuild(argv[0], stdout); return(0);}

  if(test==0) return(0);

  if(verbose>0) printf("running tests for library functions...\n");
  //TPCSTATUS status; statusInit(&status); status.verbose=verbose;
  //statusSet(&status, __func__, __FILE__, __LINE__, 0);
  i=10;
  /* axis.c */
  i++; if((ret=test_axis_tick_positions())!=0) {
    fprintf(stderr, "failed (%d).\n", ret); return(i);}
  


  if(verbose>0) printf("\nAll tests passed.\n\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
