#!/bin/bash
#: Title      : test_maskcloak
#: Date       : 2022-02-17
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../maskcloak$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"


printf "\n making test data \n"


if [ ! -f mask_2d.v ] || [ ! -f correct_2d.v ]; then

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_2d.dat

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 2 2 2 2 2 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 2 2 1 1 1 1 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 2 2 1 1 1 1 1 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 2 1 1 1 1 1 1 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 2 2 1 1 1 1 1 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 2 2 2 2 2 2 2 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_2d.dat

  asc2flat mask_2d.dat mask_2d.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask_2d.bin mask_2d.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask_2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat correct_2d.dat correct_2d.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_2d.bin correct_2d.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi



if [ ! -f mask_3d.v ] || [ ! -f correct_3dxy.v ] || [ ! -f correct_3dxyz.v ]; then

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat

  printf "2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 1 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0\n" >> mask_3d.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 0\n" >> mask_3d.dat


  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 3 3 3 3 3 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 3 3 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 1 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat

  printf "2 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "2 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "2 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "3 3 3 3 0 0 0 0 0 3 3 3 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 3 1 3 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 3 3 3 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 3 3 3 3 3 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 3 3 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 1 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 1 1 3\n" >> correct_3dxy.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 1 1 3\n" >> correct_3dxy.dat


  printf "3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_3dxyz.dat
  printf "3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 0 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 3 3 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 1 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat

  printf "2 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "2 2 2 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "2 2 2 3 0 0 0 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 3 3 3 1 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3\n" >> correct_3dxyz.dat

  printf "3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 0 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "3 3 3 3 0 0 3 3 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 1 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 3 3 1 1 1 1 1 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 3 3 3 3 3 3 3 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 1 1 3\n" >> correct_3dxyz.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 3 1 1 3\n" >> correct_3dxyz.dat

  asc2flat mask_3d.dat mask_3d.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask_3d.bin mask_3d.v 3 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb mask_3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat correct_3dxy.dat correct_3dxy.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_3dxy.bin correct_3dxy.v 3 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_3dxy.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat correct_3dxyz.dat correct_3dxyz.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT correct_3dxyz.bin correct_3dxyz.v 3 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb correct_3dxyz.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: 2D image. \n"
printf " Test case 2: No options. \n"
printf " Expected result: Correctly cloaked. \n\n"

rm -f output.v
$PROGRAM mask_2d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_2d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: 2D image. \n"
printf " Test case 2: Option -xy. \n"
printf " Expected result: Correctly cloaked. \n\n"

rm -f output.v
$PROGRAM -xy mask_2d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_2d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: 3D image. \n"
printf " Test case 2: Option -xy. \n"
printf " Expected result: Correctly cloaked. \n\n"

rm -f output.v
$PROGRAM -xy mask_3d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.0001 correct_3dxy.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.1 \n"
printf " Test case 1: 3D image. \n"
printf " Test case 2: Option -xyz. \n"
printf " Expected result: Correctly cloaked. \n\n"

rm -f output.v
$PROGRAM -xyz mask_3d.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif output.v

imgmatch -abs=0.0001 correct_3dxyz.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


