#!/bin/bash
#: Title      : test_pxl2mask
#: Date       : 2018-10-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../pxl2mask$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f dynamic.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f image.dat ] || [ ! -f image2d.v ]; then
rm -f image.bin image2d.v
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n"  > image.dat
printf "1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1\n" >> image.dat
printf "1 2 3 4 5 6 7 8 9 8 7 6 5 4 3 2\n" >> image.dat
printf "1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1\n" >> image.dat
printf "1 3 3 3 4 4 4 5 5 5 6 6 4 2 2 1\n" >> image.dat
printf "1 3 4 5 7 9 9 9 9 9 9 8 5 4 3 1\n" >> image.dat
printf "1 6 6 6 6 6 6 6 6 6 6 6 6 6 6 1\n" >> image.dat
printf "1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 3 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 4 2 1 1 1 1\n" >> image.dat
printf "2 0 0 0 0 0 0 0 1 2 5 3 1 0 0 2\n" >> image.dat
printf "3 0 0 0 0 0 0 1 3 5 7 5 1 0 0 3\n" >> image.dat
printf "4 0 0 0 0 0 1 2 4 7 8 6 2 0 0 4\n" >> image.dat
printf "5 0 0 0 0 1 3 4 5 8 9 7 3 0 0 5\n" >> image.dat
printf "6 0 0 0 1 2 3 5 7 9 9 8 6 3 0 6\n" >> image.dat
printf "7 7 8 9 9 9 9 9 9 9 9 9 9 9 8 7\n" >> image.dat
fi

if [ ! -f image2d.v ] || [ ! -f image3d.v ] || [ ! -f dynamic.v ]; then
  rm -f dynamic.v
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image2d.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=Bq/cc image2d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image2d.v x 2 image2.v
  imgcalc image2d.v x 3 image3.v
  imgcalc image2d.v x 4 image4.v
  imgcalc image2d.v x 5 image5.v
  imgcalc image2d.v + 1 image6.v
  imgcalc image2d.v - 1 image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v image2d.v image2.v image3.v image4.v image5.v image6.v image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat image2d.v image2.v image3.v image4.v image5.v image6.v image7.v dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe dynamic.v dynamic.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f pixels2d.lst ]; then
  printf "2,2,1,0\n"   >  pixels2d.lst
  printf "2,4,1,0\n"   >> pixels2d.lst
  printf "9,6,1,0\n"   >> pixels2d.lst
  printf "11,9,1,0\n"  >> pixels2d.lst
  printf "7,13,1,0\n"  >> pixels2d.lst
  printf "11,14,1,0\n" >> pixels2d.lst
  printf "15,14,1,0\n" >> pixels2d.lst
fi

if [ ! -f pixels3d.lst ]; then
  printf "2,2,1,0\n"   >  pixels3d.lst
  printf "2,4,1,0\n"   >> pixels3d.lst
  printf "9,6,1,0\n"   >> pixels3d.lst
  printf "11,9,1,0\n"  >> pixels3d.lst
  printf "7,13,1,0\n"  >> pixels3d.lst
  printf "11,14,1,0\n" >> pixels3d.lst
  printf "15,14,1,0\n" >> pixels3d.lst
  printf "2,2,4,0\n"   >> pixels3d.lst
  printf "2,4,4,0\n"   >> pixels3d.lst
  printf "9,6,4,0\n"   >> pixels3d.lst
  printf "11,9,4,0\n"  >> pixels3d.lst
  printf "7,13,4,0\n"  >> pixels3d.lst
  printf "11,14,4,0\n" >> pixels3d.lst
  printf "15,14,4,0\n" >> pixels3d.lst
fi


if [ ! -f correct_mask2d.dat ] || [ ! -f correct_mask2d.v ]; then
rm -f image.bin correct_mask2d.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > correct_mask2d.dat
printf "0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 1 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> correct_mask2d.dat

  asc2flat correct_mask2d.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin correct_mask2d.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f empty.dat ] || [ ! -f empty.v ]; then
rm -f empty.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> empty.dat

  asc2flat empty.dat empty.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT empty.bin empty.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_mask3d_1.v ]; then
  imgadd correct_mask3d_1.v correct_mask2d.v empty.v empty.v empty.v empty.v empty.v empty.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_mask3d_2.v ]; then
  imgadd correct_mask3d_2.v correct_mask2d.v empty.v empty.v correct_mask2d.v empty.v empty.v empty.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mask.vrd ]; then
  printf "corner1 := 8,14,1\n"  >  mask.vrd
  printf "corner2 := 9,14,7\n" >>  mask.vrd
fi

if [ ! -f empty_mask3d.v ]; then
  imgadd empty_mask3d.v empty.v empty.v empty.v empty.v empty.v empty.v empty.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Pixel list file. \n"
printf " Test case 2: Static 2D template image. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output_100.v
$PROGRAM image2d.v output_100.v pixels2d.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 -header=no correct_mask2d.v output_100.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Pixel list file. \n"
printf " Test case 2: Dynamic 2D template image. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output_101.v
$PROGRAM dynamic.v output_101.v pixels2d.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 -header=no correct_mask2d.v output_101.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Pixel list file with pixels only on first plane. \n"
printf " Test case 2: 3D template image. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output_102.v
$PROGRAM image3d.v output_102.v pixels2d.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 -header=no correct_mask3d_1.v output_102.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case 1: Pixel list file with pixels on two planes. \n"
printf " Test case 2: 3D template image. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output_103.v
$PROGRAM image3d.v output_103.v pixels3d.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 -header=no correct_mask3d_2.v output_103.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case 1: VRD file. \n"
printf " Test case 2: 3D template image. \n"
printf " Expected result: Correct mask image. \n\n"

rm -f output_110.v
if [ ! -f pixelsvrd.lst ]; then
  rm -f correct_mask_vrd.v
  printf "8,14,1,0\n"   >  pixelsvrd.lst
  printf "9,14,1,0\n"   >> pixelsvrd.lst
  printf "8,14,2,0\n"   >> pixelsvrd.lst
  printf "9,14,2,0\n"   >> pixelsvrd.lst
  printf "8,14,3,0\n"   >> pixelsvrd.lst
  printf "9,14,3,0\n"   >> pixelsvrd.lst
  printf "8,14,4,0\n"   >> pixelsvrd.lst
  printf "9,14,4,0\n"   >> pixelsvrd.lst
  printf "8,14,5,0\n"   >> pixelsvrd.lst
  printf "9,14,5,0\n"   >> pixelsvrd.lst
  printf "8,14,6,0\n"   >> pixelsvrd.lst
  printf "9,14,6,0\n"   >> pixelsvrd.lst
  printf "8,14,7,0\n"   >> pixelsvrd.lst
  printf "9,14,7,0\n"   >> pixelsvrd.lst
fi
if [ ! -f correct_mask_vrd.v ]; then
  $PROGRAM empty_mask3d.v correct_mask_vrd.v pixelsvrd.lst
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

$PROGRAM image3d.v output_110.v mask.vrd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 -rel=0.1 -header=no correct_mask_vrd.v output_110.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


