#!/bin/bash
#: Title      : test_imgfur
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgfur$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f plasma.dat ] || [ ! -f frames.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n making test data \n"


if [ ! -f dynamic.v ]; then
  PLANE=1
  p2t_3c -nosub plasma.dat 0.05 0.03 0.001 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.001 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.001 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.005 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.005 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.005 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.03 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.10 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.05 0.25 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v plane$PLANE'.roi'
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=2
  p2t_3c -nosub plasma.dat 0.20 0.05 0 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.002 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.002 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.002 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.05 0.01 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.20 0.01 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.20 0.80 0.01 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  PLANE=3
  p2t_3c -nosub plasma.dat 0.60 0.10 0.005 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.005 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.005 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.02 0 0 0 tis4.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.02 0 0 0 tis5.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.02 0 0 0 tis6.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.10 0.1 0 0 0 tis7.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 0.40 0.1 0 0 0 tis8.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.60 1.60 0.1 0 0 0 tis9.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent -ovr plane$PLANE.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis4.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis5.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis6.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis7.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis8.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent      plane$PLANE.dft tis9.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe plane$PLANE.dft frames.dat plane$PLANE'f.dft' F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacren plane$PLANE'f.dft' 0 @_@_Pl00$PLANE
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -zoom=2 -dim=8 plane$PLANE'f.dft' plane$PLANE.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd dynamic.v plane1.v plane2.v plane3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=kBq/ml dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt dynamic.v 2007-08-07 12:15:34
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 -dc dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  e7to63 dynamic.v dynamic.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2tif -s -rb dynamic.v dynamic.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -p dynamic.v plane1.roi dynamic.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg dynamic.svg -l dynamic.dft plasma.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n ok \n\n"
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

$PROGRAM 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM plasma.dat dynamic.v 0 0 output.v extra 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.3 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

$PROGRAM dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM plasma.dat dynamic.v 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM plasma.dat dynamic.v 0 0  1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.1.0 \n"
printf " Test case: Substrate concentration given with option -ca. \n"
printf " Expected result 1: Concentration is read correctly. \n"
printf " Expected result 2: Warning that default density and LC are used. \n\n"

$PROGRAM -d2 -ca=5.2 plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Invalid use of option -ca. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d2 -ca= plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d2 -ca plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.2.0 \n"
printf " Test case: Lumped constant given with option -lc. \n"
printf " Expected result: LC is read correctly. \n"

$PROGRAM -d2 -ca=5,2 -lc=0,82 plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "LC" "0.82"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: Lumped constant given with option -lc, without -ca. \n"
printf " Expected result: Warning that LC will not ge used. \n\n"

$PROGRAM -d2 -LC=0.82 plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC was set but is not used."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.2 \n"
printf " Test case: Invalid use of option -lc. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d2 -lc= plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d2 -lc plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n\n"


printf "\n 1.3.0 \n"
printf " Test case: Density given with option -density. \n"
printf " Expected result: Density is read correctly. \n"

$PROGRAM -d2 -ca=5.2 -density=1,02 plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "density" "1.02"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Ca" "5.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "LC not set, using default 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Density given with option, without -ca. \n"
printf " Expected result: Warning that density will not ge used. \n\n"

$PROGRAM -d2 -density=1.02 plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "tissue density was set but is not used."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.2 \n"
printf " Test case: Invalid use of option -density. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -d2 -density= plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d2 -density plasma.dat dynamic.v 0 0 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Basic tests \n"
printf "===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: FUR 40-60 min from dynamic ECAT7 image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.v
imginteg -avg -min dynamic.v 40 20 mean_40_60.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
auc=$(interpol -i -x=50 -header=no plasma.dat)
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "AUC := %s\n" $auc
imgcalc mean_40_60.v : $auc correct_fur_50.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat dynamic.v 40 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: FUR 40-60 min from dynamic ECAT6 image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.img
$PROGRAM plasma.dat dynamic.img 40 60 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: FUR from static image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.v

$PROGRAM plasma.dat mean_40_60.v 0 0 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: MR 40-60 min from dynamic ECAT7 image. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.v output2.v
$PROGRAM plasma.dat dynamic.v 40 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgcalc output.v x 750 correct_mr_50.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -Ca=6.3 -LC=0.8 -density=1.05 plasma.dat dynamic.v 40 60 output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_mr_50.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.2.0 \n"
printf " Test case: ECAT7 in Bq/cc, plasma in kBq/mL. \n"
printf " Expected result: Correct result. \n\n"

cp -f dynamic.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgunit -uc=Bq/cc temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.v

$PROGRAM plasma.dat temp.v 40 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.1 \n"
printf " Test case: ECAT7 in kBq/cc, plasma in Bq/mL and sec. \n"
printf " Expected result: Correct result. \n\n"

cp -f plasma.dat temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacunit -yconv=Bq/cc -xconv=sec temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
rm -f output.v

$PROGRAM temp.dat dynamic.v 40 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   Time range \n"
printf "===================================================================\n"

printf "\n 3.0.0 \n"
printf " Test case: User gives the same start and end time. \n"
printf " Expected result: Correct result at the specified time. \n\n"

rm -f output.v
imginteg -avg -min dynamic.v 59.5 1 mean_60.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
auc=$(interpol -i -x=60 -header=no plasma.dat)
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "AUC := %s\n" $auc
imgcalc mean_60.v : $auc correct_fur_60.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat dynamic.v 60 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_60.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case: Image data stops much earlier than time range. \n"
printf " Expected result: Error. \n\n"

esplit dynamic.v 1-14 1 short.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM plasma.dat short.v 40 60 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "integration time range oversteps data range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 \n"
printf " Test case: Plasma data stops much earlier than time range. \n"
printf " Expected result: Error. \n\n"

taccut plasma.dat 0 15 short.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM short.dat dynamic.v 40 60 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "integration time range oversteps data range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.2 \n"
printf " Test case: Plasma and image data stops much earlier than time range. \n"
printf " Expected result: Error. \n\n"

$PROGRAM short.dat short.v 40 60 output.v 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "integration time range oversteps data range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   Other image formats \n"
printf "===================================================================\n"


printf "\n 4.0.0 \n"
printf " Test case: FUR from dynamic NIfTI image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f nifti/*
ecat2nii -o=nifti -sif dynamic.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat nifti/dynamic 40 60 nifti/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v nifti/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.1 \n"
printf " Test case: FUR from static NIfTI image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f nifti/*
ecat2nii -o=nifti -sif mean_40_60.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat nifti/mean_40_60 0 0 nifti/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v nifti/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.0.2 \n"
printf " Test case: FUR from static NIfTI image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f nifti/*.sif

$PROGRAM plasma.dat nifti/mean_40_60 0 0 nifti/fur 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "nifti/mean_40_60 does not contain frame times."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n--------------------------------------------------------------\n\n"

printf "\n 4.1.0 \n"
printf " Test case: FUR from dynamic Analyze image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f ana/*
ecat2ana -o=ana -sif dynamic.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat ana/dynamic 40 60 ana/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v ana/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.1 \n"
printf " Test case: FUR from static Analyze image with SIF. \n"
printf " Expected result: Results are correct, when units in kBq/mL. \n\n"

rm -f ana/*
ecat2ana -o=ana -sif mean_40_60.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM plasma.dat ana/mean_40_60 0 0 ana/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.0001 -rel=0.1 -frames=y correct_fur_50.v ana/fur
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 4.1.2 \n"
printf " Test case: FUR from static Analyze image without SIF. \n"
printf " Expected result: Error. \n\n"

rm -f ana/*.sif

$PROGRAM plasma.dat ana/mean_40_60 0 0 ana/fur 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "ana/mean_40_60 does not contain frame times."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




rm -f ana/* nifti/*

printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

