#!/bin/bash
#: Title      : test_rescoll
#: Date       : 2023-06-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../rescoll$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f test4500.res ] || [ ! -f test4501.res ] || [ ! -f test4502.res ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test4503.res ] || [ ! -f test4512.res ] || [ ! -f test4513.res ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test4522.res ] || [ ! -f test5000.res ] || [ ! -f test6000.res ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test6001.res ] || [ ! -f test7000.res ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f valid_7_1_1.html ] || [ ! -f valid_7_2_1.html ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f valid_7_2_2.html ] || [ ! -f valid_7_3_1.html ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f valid_7_3_2.html ] || [ ! -f valid_8_0_0.html ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f valid_8_0_1.html ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

$PROGRAM 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

$PROGRAM -stupidoption output.html test450?.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case: Tabulation filename not given. \n"
printf " Expected result: Error. \n\n"

$PROGRAM test450?.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Tabulation filename with wrong extension. \n"
printf " Expected result: Error. \n\n"

$PROGRAM output.txt test450?.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "collection file extension must be .htm or .html"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Tabulation filename does not exist. \n"
printf " Expected result: No errors. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.html ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Tabulation filename exists. \n"
printf " Expected result: No errors. \n\n"

$PROGRAM output.html test450?.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f output.html ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n"

printf "\n 3.0.0 \n"
printf " Test case: No result file given. \n"
printf " Expected result: No errors. \n\n"

rm -f output.html
$PROGRAM output.html  1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "no result files to process."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.1 \n"
printf " Test case: Just one result file given. \n"
printf " Expected result: No errors. \n\n"

rm -f output.html
$PROGRAM output.html test4502.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "at least two result files must be given."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: One of result files does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res nonexisting.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "result file nonexisting.res does not exist."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.1 \n"
printf " Test case 1: One of many result files is in wrong format. \n"
printf " Test case 2: Option -strict is NOT given. \n"
printf " Expected result: Warning. \n\n"

printf "0 0 0\n1 1 1\n" > bad.res
rm -f output.html
$PROGRAM output.html test450?.res bad.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "'bad.res' not read: wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.2 \n"
printf " Test case: One of two result files is in wrong format. \n"
printf " Expected result: Warning. \n\n"

rm -f output.html
$PROGRAM output.html test4500.res bad.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "'bad.res' not read: wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "only one result file could be read."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 3.2.1 \n"
printf " Test case: Results have different model SW name. \n"
printf " Expected result: Error. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res test5000.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "different software used in result files."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.2 \n"
printf " Test case: Results have different parameter nr. \n"
printf " Expected result: Error. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res test6000.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "different parameter nr in result files."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.3 \n"
printf " Test case: Results have different parameter names. \n"
printf " Expected result: Error. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res test6001.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "different parameters in result files."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.4 \n"
printf " Test case: Result file has duplicate region names. \n"
printf " Expected result: Error. \n\n"

rm -f output.html
$PROGRAM output.html test450?.res test7000.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "test7000.res contains duplicate region names."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n"


printf "\n 4.0.0 \n"
printf " Test case 1: One of many result files is in wrong format. \n"
printf " Test case 2: Option -strict IS given. \n"
printf " Expected result: Error. \n\n"

printf "0 0 0\n1 1 1\n" > bad.res
rm -f output.html
$PROGRAM -strict output.html test450?.res bad.res 1>stdout.txt 2>&1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'bad.res'" "wrong format"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n"

printf "\n 5.0.0 \n"
printf " Test case: Option -sort not used. \n"
printf " Expected result: Files are processed in the given order. \n\n"

rm -f output.html
$PROGRAM output.html test4503.res test4502.res test4500.res test4501.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "study_number[1]" "test4503"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[2]" "test4502"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[3]" "test4500"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[4]" "test4501"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.0.1 \n"
printf " Test case: Option -sort is used. \n"
printf " Expected result: Files are processed in sorted order. \n\n"

rm -f output.html
$PROGRAM -sort output.html test4503.res test4502.res test4500.res test4501.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "study_number[1]" "test4500"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[2]" "test4501"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[3]" "test4502"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[4]" "test4503"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n-----------------------------------------------------------------\n"


printf "\n 6.0.0 \n"
printf " Test case: Result files contain the same regions. \n"
printf " Expected result: Collection file has correct contents. \n\n"

rm -f test_7_1_1.html
$PROGRAM test_7_1_1.html test450?.res 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n CHECK THE CONTENTS OF test_7_1_1.html AGAINST valid_7_1_1.html ! \n"
printf "\n CHECK THAT FILE test_7_1_1.html can be read into MS Excel ! \n\n"



printf "\n 6.1.0 \n"
printf " Test case: One result file contains one region less than others. \n"
printf " Expected result: Collection file has correct contents. \n\n"

rm -f test_7_2_1.html
resdel -o=temp.res test4501.res 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test_7_2_1.html test4500.res test4502.res test4503.res temp.res 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n CHECK THE CONTENTS OF test_7_2_1.html AGAINST valid_7_2_1.html ! \n\n"


printf "\n 6.1.1 \n"
printf " Test case: One result file contains one region more than others. \n"
printf " Expected result: Collection file has correct contents. \n\n"

rm -f test_7_2_2.html
$PROGRAM test_7_2_2.html test4500.res test4501.res test4502.res test4513.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n CHECK THE CONTENTS OF test_7_2_2.html AGAINST valid_7_2_2.html ! \n\n"





printf "\n 6.2.1 \n"
printf " Test case 1: One result file contains slightly different region names. \n"
printf " Test case 2: hemisphere field is empty, while some content in others. \n"
printf " Expected result: Collection file has correct contents. \n\n"

rm -f test_7_3_1.html
$PROGRAM test_7_3_1.html test4500.res test4501.res test4512.res test4503.res 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n CHECK THE CONTENTS OF test_7_3_1.html AGAINST valid_7_3_1.html ! \n\n"


printf "\n 6.2.2 \n"
printf " Test case 1: One result file contains slightly different region names. \n"
printf " Test case 2: plane field is empty, while some content in others. \n"
printf " Expected result: Collection file has correct contents. \n\n"

rm -f test_7_3_2.html
$PROGRAM test_7_3_2.html test4500.res test4501.res test4522.res test4503.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n CHECK THE CONTENTS OF test_7_3_2.html AGAINST valid_7_3_2.html ! \n\n"


printf "\n------------------------------------------------------------------\n"



printf "\n 7.0.0 \n"
printf " Test case: Option -list. \n"
printf " Expected result: All results are just listed. \n\n"

rm -f test_8_0_0.html
$PROGRAM -list test_8_0_0.html test*.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "file[1]" "test4500.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "file[11]" "test7000.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[1]" "test4500"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[11]" "test4500"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n CHECK THE CONTENTS OF test_8_0_0.html AGAINST valid_8_0_0.html ! \n\n"


printf "\n 7.0.1 \n"
printf " Test case: Option -list with just one result file. \n"
printf " Expected result: Results are listed without error. \n\n"

rm -f test_8_0_1.html
$PROGRAM -list test_8_0_1.html test4501.res 1>stdout.txt 2>&1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt "file[1]" "test4501.res"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt "study_number[1]" "test4501"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n CHECK THE CONTENTS OF test_8_0_1.html AGAINST valid_8_0_1.html ! \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

